<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\View\View;

class RegisteredUserController extends Controller
{
    /**
     * Vista de registro de usuario
     */
    public function create(): View
    {
        return view('auth.co-register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:clientes_usuarios,SMail'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = User::create([
            
            'SNombre' => $request->name,
            'SMail' => $request->email,
            'STelefono' => '', // O puedes agregar campo teléfono al formulario
            'IdEstado' => null, // Estado activo
            'EActivo' => true, // Usuario activo
            'SPassword' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        Auth::login($user);
        return redirect()->intended(route('admin_pagPrincipal', absolute: false)); //todo

        //return redirect(route('acerca', absolute: false));
    }
}
