<?php

namespace App\Http\Controllers;

use App\Services\DynamicQueryExecutor;
use App\Services\PlatformConfigFactory;
use Illuminate\Contracts\View\View;

class WebController extends Controller
{
    /*

    public function inicio()
    {
        return view('web/web');
    }

    public function descargas()
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'      => -1,
            'SNombreProyecto' => '-1',
            'SDescripcion'    => '-1',
            'URL_imagen'      => '-1',
            'EActivo'         => -1,
            'EVisible'        => 'Si',
        ];
        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        if ($resultadosProyectos->isEmpty()) {
            return view('web/descargas', compact('resultadosProyectos'));
        }

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $paramVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => 'Si',
            'IdProyecto'         => -1,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];
        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $paramVersion)
        );

        $idsProyectos = $resultadosProyectos->pluck('IdProyecto')->filter()->values();

        $versiones = $todasLasVersiones
            ->whereIn('IdProyecto', $idsProyectos)
            ->values();

        $parseFecha = function ($f) {
            try {
                return \Carbon\Carbon::parse($f ?: '1970-01-01');
            } catch (\Throwable $e) {
                return \Carbon\Carbon::parse('1970-01-01');
            }
        };


        $lastUpdatedByProject = $versiones
            ->filter(fn($v) => trim((string)($v->EActivo ?? 'Si')) !== 'No')
            ->groupBy('IdProyecto')
            ->map(function ($grp) use ($parseFecha) {
                $ultimo = $grp->sortByDesc(function ($v) use ($parseFecha) {
                    return $parseFecha($v->DFecha ?? null);
                })->first();
                return $ultimo ? ($ultimo->DFecha ?? null) : null;
            });


        $latestRecordByProject = $versiones
            ->filter(fn($v) => trim((string)($v->EActivo ?? 'Si')) !== 'No')
            ->groupBy('IdProyecto')
            ->map(function ($grp) use ($parseFecha) {
                return $grp->sortByDesc(function ($v) use ($parseFecha) {
                    $fecha = $parseFecha($v->DFecha ?? null)->timestamp;
                    $id    = (int)($v->IdVersionApp ?? 0);
                    return sprintf('%010d-%010d', $fecha, $id);
                })->first();
            });

        $latestVersionByProject = $latestRecordByProject->map(function ($v) {
            return (object)[
                'SVersion' => $v->SVersion ?? null,
                'DFecha'   => $v->DFecha   ?? null,
            ];
        });


        $latestByProjectOs = $versiones
            ->filter(fn($v) => trim((string)($v->EActivo ?? 'Si')) !== 'No')
            ->groupBy(function ($v) {
                return ($v->IdProyecto ?? '') . '|' . ($v->IdSistemaOperativo ?? '');
            })
            ->map(function ($grp) use ($parseFecha) {
                return $grp->sortByDesc(function ($v) use ($parseFecha) {
                    $fecha = $parseFecha($v->DFecha ?? null)->timestamp;
                    $id    = (int)($v->IdVersionApp ?? 0);
                    return sprintf('%010d-%010d', $fecha, $id);
                })->first();
            });


        $osVariantsByProjectOs = $versiones
            ->filter(fn($v) => trim((string)($v->EActivo ?? 'Si')) !== 'No')
            ->groupBy(function ($v) {
                return ($v->IdProyecto ?? '') . '|' . ($v->IdSistemaOperativo ?? '');
            })
            ->map(function ($grp) {
                return $grp->pluck('SVersionSO')
                    ->filter()
                    ->map(fn($s) => trim((string)$s))
                    ->filter()
                    ->unique()
                    ->values();
            });

        $platformsByProject = collect();
        foreach ($idsProyectos as $idp) {
            $items = [];
            foreach ($sistemasOperativos as $idSO => $so) {
                $key = "{$idp}|{$idSO}";
                if (!isset($latestByProjectOs[$key])) {
                    continue;
                }
                $ver = $latestByProjectOs[$key];
                $items[] = (object)[
                    'IdSistemaOperativo' => $idSO,
                    'SCodigo'            => $so->SCodigo ?? null,
                    'SNombre'            => $so->SNombre ?? null,
                    'SVersion'           => $ver->SVersion ?? null,
                    'DFecha'             => $ver->DFecha ?? null,
                    'SVersionSOList'     => $osVariantsByProjectOs[$key] ?? collect(),
                ];
            }
            $platformsByProject[$idp] = collect($items)
                ->sortBy('SNombre', SORT_NATURAL | SORT_FLAG_CASE)
                ->values();
        }

        return view('web/descargas', compact(
            'resultadosProyectos',
            'sistemasOperativos',
            'lastUpdatedByProject',
            'latestVersionByProject',
            'platformsByProject'
        ));
    }

    */

    public function contacto(): View
    {
        return view('web/contacto');
    }

    public function privacidad(): View
    {
        return view('web/privacidad');
    }

    public function terminos(): View
    {
        return view('web/terminos');
    }

    public function soporte(): View
    {
        return view('web/soporte');
    }



    /*
     *
     *
     *  Control de Obra
     *
     *
     */


    public function webCO(): View
    {
        return view('web/CO/webCO');
    }

    public function acercaCO(): View
    {
        return view('web/CO/acercaCO');
    }

    public function descargasCO(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 1,
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 1,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/CO/descargasCO', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }


    /*
     *
     *
     *  Activismo
     *
     *
     */


    public function webActivismo(): View
    {
        return view('web/Activismo/webActivismo');
    }

    public function acercaActivismo(): View
    {
        return view('web/Activismo/acercaActivismo');
    }

    public function descargasActivismo(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 2, // Activismo
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 2,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/Activismo/descargasActivismo', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }

    /*
    *
    *
    *  PU
    *
    *
    */


    public function webPU(): View
    {
        return view('web/PU/webPU');
    }

    public function acercaPU(): View
    {
        return view('web/PU/acercaPU');
    }

    public function descargasPU(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 4, // Precuis Unitarios
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 4,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/PU/descargasPU', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }

    /*
    *
    *
    *  Requisiciones
    *
    *
    */


    public function webRequisiciones(): View
    {
        return view('web/Requisiciones/webRequisiciones');
    }

    public function acercaRequisiciones(): View
    {
        return view('web/Requisiciones/acercaRequisiciones');
    }

    public function descargasRequisiciones(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 5, // Compras y requisiciones
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 5,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/Requisiciones/descargasRequisiciones', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }

    /*
    *
    *
    *  TarifaDiaria
    *
    *
    */


    public function webTarifaDiaria(): View
    {
        return view('web/TarifaDiaria/webTarifaDiaria');
    }

    public function acercaTarifaDiaria(): View
    {
        return view('web/TarifaDiaria/acercaTarifaDiaria');
    }

    public function descargasTarifaDiaria(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 7, // Tarifa Diaria
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 7,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/TarifaDiaria/descargasTarifaDiaria', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }

    /*
     *
     *
     *  PU
     *
     *
     */


    public function webRH(): View
    {
        return view('web/RH/webRH');
    }

    public function acercaRH(): View
    {
        return view('web/RH/acercaRH');
    }

    public function descargasRH(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 6, // Recursos Humanos
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 6,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/RH/descargasRH', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }

    /*
     *
     *
     *  Nomina
     *
     *
     */


    public function webNomina(): View
    {
        return view('web/Nomina/webNomina');
    }

    public function acercaNomina(): View
    {
        return view('web/Nomina/acercaNomina');
    }

    public function descargasNomina(): View
    {
        $executeQuery = new DynamicQueryExecutor();

        $parametrosProyectos = [
            'IdProyecto'       => 3, // Nomina
            'SNombreProyecto'  => '-1',
            'SDescripcion'     => '-1',
            'URL_imagen'       => '-1',
            'EActivo'          => '-1',
            'EVisible'         => 'Si',
        ];

        $resultadosProyectos = collect(
            $executeQuery->executeQueryByName('master_proyecto', $parametrosProyectos)
        );

        $paramSO = [
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombre'            => '-1',
            'EActivo'            => 'Si',
        ];
        $sistemasOperativos = collect(
            $executeQuery->executeQueryByName('master_sistemas_operativos', $paramSO)
        )->keyBy('IdSistemaOperativo');

        $parametrosVersion = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => 3,
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $todasLasVersiones = collect(
            $executeQuery->executeQueryByName('master_versiones_app', $parametrosVersion)
        );

        // Obtener archivos
        $archivosPorVersion = collect();
        if ($todasLasVersiones->isNotEmpty()) {
            $parametrosArchivos = [
                'IdVersionAppArchivos' => -1,
                'IdVersionApp'         => -1,
                'URL_Ejecutable'       => '-1',
                'URL_Reportes'         => '-1',
                'URL_Scripts'          => '-1',
                'URL_Tienda'           => '-1',
            ];

            $resultadosArchivos = collect(
                $executeQuery->executeQueryByName('master_versiones_app_archivos', $parametrosArchivos)
            );

            $archivosPorVersion = $resultadosArchivos->groupBy(function ($row) {
                return isset($row->IdVersionApp) ? (string)$row->IdVersionApp : '';
            });
        }

        // Agrupar versiones por Sistema Operativo dinámicamente
        $versionesPorSO = $todasLasVersiones->groupBy('IdSistemaOperativo');

        // Construir array de plataformas disponibles usando el Factory
        $platforms = [];

        foreach ($versionesPorSO as $idSO => $versions) {
            // Obtener info del SO desde la BD
            $so = $sistemasOperativos->get($idSO);
            if (!$so) {
                continue;
            }

            $codigo = strtolower(trim($so->SCodigo ?? ''));
            if (empty($codigo)) {
                continue;
            }

            // Obtener configuración del Factory
            $config = PlatformConfigFactory::getPlatformConfig($codigo, true);
            if (!$config) {
                continue;
            }

            // Agregar plataforma con toda su configuración
            $platforms[] = [
                'codigo'    => $codigo,
                'idSO'      => $idSO,
                'config'    => $config,
                'versions'  => $versions->values(),
                'order'     => $config['order'] ?? 999,
            ];
        }

        // Ordenar plataformas por orden de prioridad
        usort($platforms, function ($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        $proyecto = $resultadosProyectos->first();

        $videoUrlProyecto = null;
        $docUrlProyecto = null;

        if ($todasLasVersiones->isNotEmpty()) {
            $versionMasReciente = $todasLasVersiones->sortByDesc('DFecha')->first();
            $videoUrlProyecto = $versionMasReciente->URL_Video ?? null;
        }

        return view('web/Nomina/descargasNomina', compact(
            'platforms',
            'resultadosProyectos',
            'archivosPorVersion',
            'videoUrlProyecto',
            'docUrlProyecto'
        ));
    }


    /*
     *
     *
     *  ERP
     *
     *
     */


    public function webERP(): View
    {
        return view('web/ERP/webERP');
    }

    public function acercaERP(): View
    {
        return view('web/ERP/acercaERP');
    }

    public function descargasERP(): View {
        return view('web/ERP/descargasERP');
    }





}
