<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\DynamicQueryExecutor;


class AdminWebController extends Controller
{
    public function admin_pagPrincipal()
    {
        return view('layouts/admin/admin_pagPrincipal');
    }

    public function dashboard()
    {
        return view('modulos/admin/catalogos/admin_dashboard');
    }

    public function proyectos()
    {
        return view('modulos/admin/catalogos/admin_proyectos');
    }

    public function usuarios()
    {
        return view('modulos/admin/catalogos/admin_usuario');
    }
  
    public function documentacion()
    {
        return view('modulos/admin/catalogos/admin_documentacion');
    }
       public function mostrarProyecto()
{
    // Instancia del servicio que ejecuta consultas dinámicas
    $queryExecutor = new DynamicQueryExecutor();

    // Parámetros de entrada con valores por defecto
    $parametros = [
        'IdProyecto' => -1,
        'SNombreProyecto' => '-1',
        'SDescripcion' => '-1',
        'URL_imagen' => '-1',
        'EActivo' => '-1',
        'EVisible' => '-1',
    ];

    // Ejecutar la consulta almacenada llamada "master_proyecto"
    $resultados = $queryExecutor->executeQueryByName('master_proyecto', $parametros);

    // Convertir el resultado en colección y filtrar valores nulos
    $resultados = collect($resultados)->filter(function ($item) {
        return $item->IdProyecto !== null;
    });

    // Retornar la vista (ajusta la ruta según tu estructura)
    return view('modulos/admin/catalogos/admin_proyectos', compact('resultados'));
}

public function insertarProyecto(Request $request)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    $parametros = [
        'SNombreProyecto' => $request->input('SNombreProyecto', '-1'),
        'SDescripcion'    => $request->input('SDescripcion', '-1'),
        'URL_Imagen'      => $request->input('URL_Imagen', '-1'),
        'EActivo'         => $request->input('EActivo', 'Si'),
        'EVisible'        => $request->input('EVisible', 'Si'),
    ];

    try {
        $queryExecutor->executeQueryByName('insertar_master_proyecto', $parametros);
        return redirect()->back()->with('success', 'Proyecto agregado correctamente.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Error al insertar proyecto: ' . $e->getMessage());
    }
}
public function updateProyecto(Request $request)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    // Validar que venga el IdProyecto
    $idProyecto = $request->input('IdProyecto');
    if (!$idProyecto) {
        return redirect()->back()->with('error', 'ID de proyecto no proporcionado.');
    }

    // Parametros que usará la consulta SQL (deben coincidir con tu stored query)
    $parametros = [
        'IdProyecto'      => $idProyecto,
        'SNombreProyecto' => $request->input('SNombreProyecto', '-1'),
        'SDescripcion'    => $request->input('SDescripcion', '-1'),
        'URL_Imagen'      => $request->input('URL_Imagen', '-1'),
        'EActivo'         => $request->input('EActivo', 'Si'),
        'EVisible'        => $request->input('EVisible', 'Si'),
    ];

    try {
        // Ejecutar la consulta dinámica de actualización
        $queryExecutor->executeQueryByName('update_master_proyecto', $parametros);

        return redirect()->back()->with('success', 'Proyecto actualizado correctamente.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Error al actualizar proyecto: ' . $e->getMessage());
    }
}

public function verProyectoVersiones($id)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    try {
        // 🔸 1. Consultar información del proyecto
        $parametrosProyecto = [
            'IdProyecto'      => $id,
            'SNombreProyecto' => '-1',
            'SDescripcion'    => '-1',
            'URL_imagen'      => '-1',
            'EActivo'         => '-1',
            'EVisible'        => '-1',
        ];

        $resultadoProyecto = $queryExecutor->executeQueryByName('master_proyecto', $parametrosProyecto);

        if (empty($resultadoProyecto)) {
            return redirect()->back()->with('error', 'Proyecto no encontrado.');
        }

        $proyecto = $resultadoProyecto[0];

        // 🔸 2. Consultar las versiones que pertenecen a este proyecto
        $parametrosVersiones = [
            'IdVersionApp'       => -1,
            'IdSistemaOperativo' => -1,
            'SCodigo'            => '-1',
            'SNombreSoftware'    => '-1',
            'SDescripcion'       => '-1',
            'SVersion'           => '-1',
            'DFecha'             => '-1',
            'SVersionSO'         => '-1',
            'STamanio'           => '-1',
            'SResumenVersion'    => '-1',
            'SMejorasVersion'    => '-1',
            'SRequisitos'        => '-1',
            'SRecomendaciones'   => '-1',
            'EActivo'            => '-1',
            'IdProyecto'         => $id, // ← Aquí filtramos por el proyecto actual
            'URL_PDF'            => '-1',
            'URL_Video'          => '-1',
        ];

        $versiones = $queryExecutor->executeQueryByName('master_versiones_app', $parametrosVersiones);

        // 🔸 3. Enviar datos a la vista
        return view('modulos.admin.catalogos.proyectos.admin_ProyectosVersiones', [
            'proyecto'  => $proyecto,
            'versiones' => $versiones,
        ]);
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Error al cargar el proyecto: ' . $e->getMessage());
    }
}

public function guardarVersionProyecto(Request $request)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    // ✅ Validación de los campos
    $request->validate([
        'IdProyecto' => 'required|integer',
        'version' => 'required|string|max:50',
        'IdSO' => 'required|integer',
        'SCodigo' => 'nullable|string|max:50',
        'descripcion' => 'required|string',
        'resumen' => 'required|string',
        'mejoras' => 'required|string',
        'requisitos' => 'required|string',
        'recomendaciones' => 'required|string',
        'version_so' => 'required|string|max:100',
        'tamano' => 'required|string|max:50',
        'documentacion' => 'required|file|mimes:pdf|max:5120',
        'ejecutable' => 'required|file|mimes:exe,zip|max:51200',
        'reporte' => 'required|file|mimes:pdf,docx|max:5120',
        'script' => 'required|file|mimes:pdf|max:5120',
        'url_video' => 'required|url',
        'url_tienda' => 'required|url',
    ]);

    try {
        // 📁 Rutas donde se guardarán los archivos (dentro de /public/uploads)
        $basePath = public_path('uploads/versiones/');
        $docsPath = $basePath . 'docs/';
        $exePath = $basePath . 'ejecutables/';
        $reportPath = $basePath . 'reportes/';
        $scriptPath = $basePath . 'scripts/';

        // Crear carpetas si no existen
        foreach ([$docsPath, $exePath, $reportPath, $scriptPath] as $path) {
            if (!file_exists($path)) {
                mkdir($path, 0777, true);
            }
        }

        // 📦 Guardar archivos manualmente (en /public/uploads/versiones/)
        $documentoNombre = time() . '_' . $request->file('documentacion')->getClientOriginalName();
        $ejecutableNombre = time() . '_' . $request->file('ejecutable')->getClientOriginalName();
        $reporteNombre = time() . '_' . $request->file('reporte')->getClientOriginalName();
        $scriptNombre = time() . '_' . $request->file('script')->getClientOriginalName();

        $request->file('documentacion')->move($docsPath, $documentoNombre);
        $request->file('ejecutable')->move($exePath, $ejecutableNombre);
        $request->file('reporte')->move($reportPath, $reporteNombre);
        $request->file('script')->move($scriptPath, $scriptNombre);

        // 🧾 Rutas públicas (para la base de datos)
        $urlDocs = '/uploads/versiones/docs/' . $documentoNombre;
        $urlExe = '/uploads/versiones/ejecutables/' . $ejecutableNombre;
        $urlReporte = '/uploads/versiones/reportes/' . $reporteNombre;
        $urlScript = '/uploads/versiones/scripts/' . $scriptNombre;

        // 🔹 Parámetros para tu consulta dinámica (ajusta a tus nombres de stored query)
        $parametros = [
            'IdProyecto'       => $request->input('IdProyecto'),
            'SVersion'         => $request->input('version'),
            'IdSistemaOperativo' => $request->input('IdSO'),
            'SCodigo'          => $request->input('SCodigo', '-1'),
            'SDescripcion'     => $request->input('descripcion'),
            'SResumenVersion'  => $request->input('resumen'),
            'SMejorasVersion'  => $request->input('mejoras'),
            'SRequisitos'      => $request->input('requisitos'),
            'SRecomendaciones' => $request->input('recomendaciones'),
            'SVersionSO'       => $request->input('version_so'),
            'STamanio'         => $request->input('tamano'),
            'EActivo'          => $request->input('EActivo', 'Si'),
            'URL_PDF'          => $urlDocs,
            'URL_Video'        => $request->input('url_video'),
        ];

        // Ejecutar la query de inserción de versión
        $queryExecutor->executeQueryByName('insertar_master_versiones_app', $parametros);

        // 🔹 Parámetros para insertar los archivos relacionados
        $parametrosArchivos = [
            'IdVersionesApp' => -1, // tu stored procedure debe resolver el último ID insertado
            'URL_Ejecutable' => $urlExe,
            'URL_Reportes'   => $urlReporte,
            'URL_Scripts'    => $urlScript,
            'URL_Tienda'     => $request->input('url_tienda'),
        ];

        $queryExecutor->executeQueryByName('insertar_master_versiones_app_archivos', $parametrosArchivos);

        return redirect()->back()->with('success', 'Versión agregada correctamente.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Error al guardar versión: ' . $e->getMessage());
    }
}


public function adminCargarProyecto($id)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    // Traemos la información del proyecto
    $parametrosProyecto = [
        'IdProyecto' => $id,
        'SNombreProyecto' => '-1',
        'SDescripcion' => '-1',
        'URL_imagen' => '-1',
        'EActivo' => '-1',
        'EVisible' => '-1',
    ];

    $resultadoProyecto = $queryExecutor->executeQueryByName('master_proyecto', $parametrosProyecto);

    if (empty($resultadoProyecto)) {
        return redirect()->back()->with('error', 'Proyecto no encontrado.');
    }

    $proyecto = $resultadoProyecto[0]; // ✅ aquí tenemos el proyecto

    // Traemos los sistemas operativos (ajusta el nombre si tu consulta se llama distinto)
    $parametrosSO = [
        'IdSistemaOperativo' => -1,
        'SNombre' => '-1',
        'EActivo' => '-1',
    ];

    $sistemasOperativos = $queryExecutor->executeQueryByName('master_sistemas_operativos', $parametrosSO);

 
    return view('layouts.admin.adminCargarProyecto', [
        'proyecto' => $proyecto,
        'sistemasOperativos' => $sistemasOperativos,
    ]);
}



public function insertarVersion(Request $request)
{
    $queryExecutor = new \App\Services\DynamicQueryExecutor();

    $parametros = [
        'IdProyecto'        => $request->input('IdProyecto'),
        'IdSistemaOperativo'=> $request->input('IdSO'),
        'SCodigo'           => $request->input('SCodigo'),
        'SDescripcion'      => $request->input('descripcion'),
        'SVersion'          => $request->input('version'),
        'SVersionSO'        => $request->input('version_so'),
        'STamanio'          => $request->input('tamano'),
        'SResumenVersion'   => $request->input('resumen'),
        'SMejorasVersion'   => $request->input('mejoras'),
        'SRequisitos'       => $request->input('requisitos'),
        'SRecomendaciones'  => $request->input('recomendaciones'),
        'EActivo'           => $request->input('EActivo'),
        'URL_PDF'           => $request->input('documentacion'),
        'URL_Video'         => $request->input('url_video'),
        'URL_Tienda'        => $request->input('url_tienda'),
    ];

    try {
        $queryExecutor->executeQueryByName('insertar_master_versiones_app', $parametros);

        return redirect()->route('admin_proyectos_ver', ['id' => $request->IdProyecto])
            ->with('success', 'Versión agregada correctamente.');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Error al insertar versión: ' . $e->getMessage());
    }
}


}
