<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User; // Asegúrate de que tu modelo se llama User o ajusta según tu caso
use App\Models\Departamento; // Si tienes un modelo para departamentos
use App\Models\Puesto; // Si tienes un modelo para puestos

class EditarPerfilController extends Controller
{
    /**
     * Mostrar el formulario de edición del perfil
     */
    public function edit()
    {
        $user = Auth::user();
        
        // datos de ejemplo
        $departamentos = [
            (object)['id' => 1, 'nombre' => 'Ventas'],
            (object)['id' => 2, 'nombre' => 'Marketing'],
            (object)['id' => 3, 'nombre' => 'TI'],
            (object)['id' => 4, 'nombre' => 'Recursos Humanos'],
        ];
        
        $puestos = [
            (object)['id' => 1, 'nombre' => 'Gerente'],
            (object)['id' => 2, 'nombre' => 'Coordinador'],
            (object)['id' => 3, 'nombre' => 'Analista'],
            (object)['id' => 4, 'nombre' => 'Asistente'],
        ];
        
        // Si tienes modelos reales, descomenta estas líneas:
        // $departamentos = Departamento::all();
        // $puestos = Puesto::all();
        
        return view('modulos.admin.admin_editPerfil', compact('user', 'departamentos', 'puestos'));
    }

    /**
     * Actualizar el perfil del usuario
     */
    public function update(Request $request)
    {
        $user = Auth::user();
        
        $validated = $request->validate([
            'SUsuario' => 'required|string|max:50|unique:users,SUsuario,' . $user->id,
            'SNombre' => 'required|string|max:100',
            'SMail' => 'required|email|max:100|unique:users,SMail,' . $user->id,
            'STelefono' => 'nullable|string|max:20',
            'IdDepartamento' => 'required|integer',
            'IdPuesto' => 'required|integer',
        ]);
        
        //$user->update($validated);
        
        //return redirect()->route('profile.edit')
       //     ->with('status', 'Perfil actualizado correctamente');
    }

    /**
     * Actualizar la contraseña del usuario
     */
    public function updatePassword(Request $request)
    {
        $request->validate([
            'newPassword' => 'required|string|min:8|confirmed',
        ]);
       /* 
        $user = Auth::user();
        $user->SPassword = bcrypt($request->newPassword);
        $user->save();
        
        return response()->json(['success' => true, 'message' => 'Contraseña actualizada correctamente']);
    */
        }
}
