<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PerfilController extends Controller
{
    /**
     * Mostrar el formulario de edición del perfil
     */
    public function edit()
    {
        $user = Auth::user();
        
        return view('modulos.perfil', compact('user'));
    }

    /**
     * Actualizar el perfil del usuario
     */
    public function update(Request $request)
    {
        $user = Auth::user();
        
        $validated = $request->validate([
            'SNombre' => 'required|string|max:100',
            'SMail' => 'required|email|max:100|unique:users,SMail,' . $user->id,
            'STelefono' => 'nullable|string|max:20',
        ]);
        
      //  $user->update($validated);
        
        return redirect()->route('perfil.edit')
            ->with('status', 'Perfil actualizado correctamente');
    }

    /**
     * Actualizar la contraseña del usuario
     */
    public function updatePassword(Request $request)
    {
        $request->validate([
            'newPassword' => 'required|string|min:8|confirmed',
        ]);
        
        /*
        $user = Auth::user();
        $user->SPassword = bcrypt($request->newPassword);
        $user->save();
        */
        return response()->json(['success' => true, 'message' => 'Contraseña actualizada correctamente']);
    }
}