<?php

namespace App\Http\Controllers\Clientes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ClienteVistaProyectoController extends Controller
{
    public function clienteVistaProyecto()
    {
        // Solo muestra la vista
                return view('layouts/cliente/clienteVistaProyecto');

    }
   public function clienteDescargaProyecto()
    {
        // Solo muestra la vista
                return view('layouts/cliente/clienteDescargaProyecto');

    }
    public function store(Request $request)
    {
    if ($request->hasFile('ComprobanteArchivo')) {
        $archivo = $request->file('ComprobanteArchivo');
        $extension = $archivo->getClientOriginalExtension();
        $nombreArchivo = 'ACTIVISMO' . '.' . $extension;

        $path = Storage::disk('s3')->put(
            "Descargas/Proyectos/Activismo/Instalador/{$nombreArchivo}",
            file_get_contents($archivo)
        );

            if ($path) {
              $url = Storage::disk('s3')->url('Descargas/Proyectos/Activismo/Instalador/' . $nombreArchivo);

               return back()->with('success', 'Archivo subido correctamente.')->with('file_url', $url);

            } else {
              $url = Storage::disk('s3')->url('Descargas/Proyectos/Activismo/Instalador/' . $nombreArchivo);
               
                dd(['fallo subida \n path' => $path, 'url' => $url]);

            }
    }   

        return back()->withErrors(['ComprobanteArchivo' => 'No se detectó el archivo a subir.']);

    }

}
///////////////////////////////////////////////////////////////////
/*
private string $folderGrupos = 'Categorias/Grupos';
    private string $diskCupones = 'Almacenmaiento/Cupones';

    public function guardarGrupoCategoria(Request $request)
    {
        try {
            // 1) Validación
            $request->validate([
                'SNombre'   => 'required|string|max:50',
                'EActivo'   => 'nullable|in:Si,No',
                'URL_icono' => 'nullable|file|mimes:jpg,jpeg,png,webp|max:2048',
            ], [
                'SNombre.required' => 'Falta el nombre del grupo.',
                'SNombre.max'      => 'El nombre no puede exceder 50 caracteres.',
                'EActivo.in'       => 'El valor de Activo debe ser Si o No.',
                'URL_icono.mimes'  => 'El ícono debe ser jpg, jpeg, png o webp.',
                'URL_icono.max'    => 'El ícono no debe superar los 2MB.',
            ]);

            // 2) Normalizar nombre
            $rawNombre         = (string) $request->input('SNombre', '');
            $nombreNormalizado = preg_replace('/\s+/', ' ', trim($rawNombre));

            // 3) Verificar duplicado (nombre global, case-insensitive)
            $qe = new DynamicQueryExecutor();
            $dupParams = [
                'IdGrupoCategoria' => -1,
                'SCodigo'          => '-1',
                'SNombre'          => $nombreNormalizado, // tu SP suele buscar LIKE; filtramos luego exacto
                'URL_icono'        => '-1',
                'EActivo'          => '-1',
            ];
            $posibles = $qe->executeQueryByName('admin_grupo_categoria', $dupParams);

            $duplicado = collect($posibles ?? [])->first(function ($row) use ($nombreNormalizado) {
                $n = isset($row->SNombre) ? preg_replace('/\s+/', ' ', trim($row->SNombre)) : '';
                return strcasecmp($n, $nombreNormalizado) === 0;
            });

            if ($duplicado) {
                return back()->withInput()->withErrors([
                    'SNombre' => 'Ya existe un grupo con ese nombre.',
                ]);
            }

            // 4) Subida opcional de ícono
            $urlIcono = null;
            if ($request->hasFile('URL_icono')) {
                $img      = $request->file('URL_icono');
                $ext      = strtolower($img->getClientOriginalExtension());
                $slug     = Str::slug($nombreNormalizado ?: 'grupo') ?: 'grupo';
                $fechaYmd = date('Ymd');
                $horaHis  = date('His');

                $fileName     = "grupo_{$fechaYmd}_{$horaHis}_{$slug}.{$ext}";
                $pathRelativo = "{$this->folderGrupos}/{$fileName}";

                Storage::disk($this->diskCupones)->put($pathRelativo, file_get_contents($img));

                // Si tu disk('s3') tiene URL configurada, puedes usar ->url($pathRelativo).
                // Uso URL directa estilo S3 para mantener consistencia con tu guardarCategoria:
                $bucket  = env('AWS_BUCKET');
                $region  = env('AWS_DEFAULT_REGION', 'us-east-2');
                $urlIcono = "https://{$bucket}.s3.{$region}.amazonaws.com/{$pathRelativo}";
            }

            // 5) Generar folio
            $folio = (new CreaFolio())->generarFolio('admin_grupo_categoria', 1);

            // 6) Mapear EActivo (default 'Si' como en tu Blade)
            $EActivo = $request->has('EActivo')
                ? ($request->input('EActivo') === 'Si' ? 'Si' : 'No')
                : 'Si';

            // 7) Insertar
            $insertParams = [
                'SCodigo'   => $folio,
                'SNombre'   => $nombreNormalizado,
                'URL_icono' => $urlIcono, // string|null (si tu SP aún no lo acepta, elimínalo)
                'EActivo'   => $EActivo,
            ];

            $qe->executeQueryByName('insert_admin_grupo_categoria', $insertParams);

            // 8) Respuesta OK
            return redirect()
                ->route('crearGrupoCategoria')
                ->with('success', 'Grupo de categoría creado correctamente.');
        } catch (\Throwable $e) {
            return back()
                ->withInput()
                ->withErrors(['error' => 'Error al crear el grupo: ' . $e->getMessage()]);
        }
    }
        */