<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
        protected $table = 'clientes_usuarios';
        public $timestamps = false;

        protected $primaryKey = 'IdUsuarioCliente';

    protected $fillable = [
        'SPassword',
        'SNombre',
        'SMail',
        'STelefono',
        'IdEstado',
        'EActivo',
        'remember_token',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'SPassword',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
      //      'email_verified_at' => 'datetime',
            'SPassword' => 'hashed',
            'EActivo' => 'boolean'
        ];
    }
       /**
     * IMPORTANTE: Para la autenticación
     */
    public function getAuthPassword()
    {
        return $this->SPassword;
    }

    public function getEmailForPasswordReset()
    {
        return $this->SMail;
    }
}
