<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AlmacenService {

    protected $queryExecutor;

    public function __construct(DynamicQueryExecutor $queryExecutor) {
        $this->queryExecutor = $queryExecutor;
    }

    public function generarNuevoCodigoSalida() {
        $creaFolio = new CreaFolio();
        $codigo = $creaFolio->generarFolio('almacen_salida', 11);
        return $codigo;
    }

    public function obtenerSalidasAlmacen($contrato) {
        return $this->queryExecutor->executeQueryByName('almacen_salida', [
            'Contrato' => $contrato,
            'Usuario' => -1,
            'FechaInicio' => '2000-01-01',
            'FechaFinal' => '2025-01-01',
            'Vista' => -1,
        ]);
    }

    public function obtenerDetalleSalida($contrato, $codigo) {
        return $this->queryExecutor->executeQueryByName('almacen_salida_detalle', [
            'Contrato' => $contrato,
            'Folio' => $codigo,
        ]);
    }

    //nueva consulta detalles salida
    public function obtenerBitacoraDeSalidaPeps($codigo) {
        return $this->queryExecutor->executeQueryByName('bitacoradesalidapeps', [
            'FolioSalida' => $codigo
        ]);
    }

    public function obtenerDatosParaSalida() {
        $sContrato = Session::get('sContrato');
        return [
            'proyecto' => $this->queryExecutor->executeQueryByName('ordenesdetrabajo_presu_val', [
                'Contrato' => $sContrato,
                'Tipo' => 'PROYECTO', 
                'Estatus' => '-1',
            ]),
            'almacenes' => $this->queryExecutor->executeQueryByName('almacenes_salida', [
                'Usuario' => Auth::user()->sIdUsuario,
            ]),
            'centrosCostos' => $this->queryExecutor->executeQueryByName('ordenesdetrabajo_req', [
                'Contrato' => $sContrato,
                'Tipo' => 'CENTRO_COSTO',  
            ]),
            'movimientoSalida' => $this->queryExecutor->executeQueryByName('movimientosdealmacen_salida', []),
            'plataformas' => $this->queryExecutor->executeQueryByName('plataformas', [
                'Plataforma' => '-1',
            ]),
            'firmantes' => $this->queryExecutor->executeQueryByName('rd_firmas', [
                'idFirma' => '-1',
                'Tipo' => '5',
                'Contrato' => $sContrato,
            ]),
        ];
    }
    
    

    public function guardarSalidaAlmacen($data) {
        $data['sIdUsuario'] = Auth::user()->sIdUsuario;
        $data['sContrato'] = Session::get('sContrato');
    
        $dataDB = [
            'sFolioSalida' => $data['codigo'],
            'dFechaSolicitud' => $data['fecha_creacion'],
            'dFechaSalida' => $data['fecha_salida'],
            'IdAlmacen' => $data['almacen'],
            'sNumeroOrden' => $data['proyecto'],
            'sNumeroOrdenCC' => $data['centro_costo'],
            'IdTipo' => $data['tipo_salida'],
            'sIdPlataforma' => $data['plataforma'],
            'sNombre' => $data['recibe_salida'],
            'Referencia' => $data['referencia'],
            'sTipoUso' => $data['tipo_uso'],
            'IdFirma' => $data['firmantes'],
            'mComentarios' => $data['comentarios'],
            'sIdUsuario' => $data['sIdUsuario'],
            'sContrato' => $data['sContrato'],
            'EstadoVista' => 'ACTIVAS',
        ];
    
        DB::table('almacen_salida')->insert($dataDB);
    }
    
    public function actualizarSalidaAlmacen($sFolioSalida, $validatedData) {
        $data = [
            'sFolioSalida' => $validatedData['codigo'],
            'dFechaSalida' => $validatedData['fecha_salida'],  
            'dFechaSolicitud' => $validatedData['fecha_creacion'],  
            'IdAlmacen' => $validatedData['almacen'],
            'sNumeroOrden' => $validatedData['proyecto'],
            'sNumeroOrdenCC' => $validatedData['centro_costo'],
            'IdTipo' => $validatedData['tipo_salida'],
            'sIdPlataforma' => $validatedData['plataforma'],
            'sNombre' => $validatedData['recibe_salida'],
            'Referencia' => $validatedData['referencia'],
            'sTipoUso' => $validatedData['tipo_uso'],
            'IdFirma' => $validatedData['firmantes'],
            'mComentarios' => $validatedData['comentarios'],
            'EstadoVista' => 'ACTIVAS',
        ];

        $sContrato = Session::get('sContrato');
        DB::table('almacen_salida')
            ->where('sContrato', $sContrato)
            ->where('sFolioSalida', $sFolioSalida)
            ->update($data);
    }
}