<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;

class CreaFolio
{

    // Funcion para consultar el Folio
    public function consultarFolio($stabla)
    {
        // Obtener la configuración de folios para la tabla y empresa específicas
        Log::info("Buscando configuración de folios para la tabla: " . $stabla);

        $configuracion = DB::table('master_cnf_folios')
            ->whereRaw("LOWER(TRIM(STabla)) = LOWER(TRIM(?))", [$stabla])
            ->where('EAplicar', 'Si')
            ->first();

        if (!$configuracion) {
            Log::error("No se encontró configuración para la tabla: " . $stabla );
            return 'No se encontró configuración para el folio.';
        }

        $siguiente = max($configuracion->IniciarEn, $configuracion->ValorActual + 1);
        $folio = $configuracion->SPrefijo . str_pad($siguiente, $configuracion->NumDig, '0', STR_PAD_LEFT);

        return $folio;
    }


    // Función para actualizar la tabla
    public function generarFolio($stabla)
    {
        // Obtener la configuración de folios para la tabla y empresa específicas
        Log::info("Buscando configuración de folios para la tabla: " . $stabla);

        $configuracion = DB::table('master_cnf_folios')
            ->whereRaw("LOWER(TRIM(STabla)) = LOWER(TRIM(?))", [$stabla])
            ->where('EAplicar', 'Si')
            ->first();

        if (!$configuracion) {
            Log::error("No se encontró configuración para la tabla: " . $stabla );
            return 'No se encontró configuración para el folio.';
        }

        $siguiente = max($configuracion->IniciarEn, $configuracion->ValorActual + 1);

        // Armar el folio con ceros y prefijo
            // $siguiente es Iteración del folio
            // $NumDig numero de dígitos que debe tener el folio
            // '0' es el carácter con el que se rellenará el folio
        $folio = $configuracion->SPrefijo . str_pad($siguiente, $configuracion->NumDig, '0', STR_PAD_LEFT);

        // Actualizar el valor actual en la tabla de folios
        DB::table('master_cnf_folios')
            ->where('STabla', $stabla)
            ->update(['ValorActual' => $siguiente]);

        return $folio;
    }

    /* 
    public function AutoFolio($nombreTabla, $Contrato = '', $Grupo = '') {
        // Recuperar la configuración de folios para la tabla y empresa específicas
        Log::info("Buscando configuración de folios para la tabla: " . $nombreTabla);
        
        $configuracion = DB::table('master_cnf_folios')
            ->whereRaw("LOWER(TRIM(TablaNombre)) = LOWER(TRIM(?))", [$nombreTabla])
            ->where('Aplicar', 'Si')
            ->first();
    
        if (!$configuracion) {
            Log::error("No se encontró configuración para la tabla: " . $nombreTabla);
            return 'No se encontró configuración para el folio.';
        }
    
        // Aplicar filtros según Grupo o Contrato
        if (!empty($Grupo)) {
            $configuracion = DB::table('master_cnf_folios')
                ->where('TablaNombre', $nombreTabla)
                ->where('sGrupo', $Grupo)
                ->where('Aplicar', 'Si')
                ->first();
        }
    
        if (!$configuracion) {
            return 'No se encontró configuración para el folio.';
        }
    
        // Construcción del filtro para sContrato
        $filtroEmpresa = '';
        if (!empty($Contrato)) {
            // Verificar si la tabla tiene la columna sContrato antes de agregar el filtro
            $columnExists = DB::select("SHOW COLUMNS FROM $nombreTabla LIKE 'sContrato'");
            if (!empty($columnExists)) {
                $filtroEmpresa .= ' AND sContrato = ?';
            }
        }
    
        // Construir la consulta para encontrar el último folio
        $campoFolio = $configuracion->CampoNombre;
        $likePattern = $configuracion->Prefijo . '%' . ($configuracion->Complemento ?? '');
        
        $query = "SELECT MAX($campoFolio) AS ultimoFolio FROM {$configuracion->TablaNombre} WHERE $campoFolio LIKE ? $filtroEmpresa";
        
        Log::info("Consulta SQL generada: " . $query, ['likePattern' => $likePattern]);
    
        $params = [$likePattern];
        if (!empty($Contrato) && !empty($columnExists)) {
            $params[] = $Contrato;
        }
    
        $ultimoFolio = DB::select($query, $params);
    
        Log::info("Resultado de consulta: ", $ultimoFolio);
    
        if (empty($ultimoFolio) || empty($ultimoFolio[0]->ultimoFolio)) {
            // Si no hay folios existentes, comenzar desde IniciarEn
            $nextNumber = $configuracion->IniciarEn;
        } else {
            // Extraer el número actual del folio y calcular el siguiente
            $ultimoFolioTexto = $ultimoFolio[0]->ultimoFolio;
            $lastFolioNumber = substr($ultimoFolioTexto, strlen($configuracion->Prefijo));
            $sizeLastFolioNumber = strlen($lastFolioNumber) - strlen($configuracion->Complemento ?? '');
            $lastFolioNumber = substr($lastFolioNumber, 0, $sizeLastFolioNumber);
            $lastFolioNumber = intval(preg_replace('/[^0-9]/', '', $lastFolioNumber));
            $nextNumber = $lastFolioNumber + 1;
        }
    
        // Formatear el nuevo número de folio
        $formattedNumber = sprintf("%0{$configuracion->NumDig}d", $nextNumber);
    
        // Construir el nuevo folio
        $nuevoFolio = $configuracion->Prefijo . $formattedNumber . ($configuracion->Complemento ?? '');
    
        return $nuevoFolio;
    }

    */
}
