<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

class DynamicQueryExecutor
{
    protected $table = 'master_consultassql';

    public function executeQueryByName($queryName, array $parameters)
    {
        DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        $queryRecord = DB::table($this->table)->where('NombreConsulta', $queryName)->first();

        if (!$queryRecord) {
            throw new \Exception("Consulta no encontrada: {$queryName}");
        }

        $sql = $queryRecord->SQL;

        foreach ($parameters as $key => $value) {
            // Usar comillas para strings y dejar números tal cual
            $escapedValue = is_numeric($value) ? $value : "'" . addslashes($value) . "'";
            // Asegurar que cada parámetro es sustituido
            $sql = preg_replace("/:$key\b/", $escapedValue, $sql);
        }

        try {
            return DB::select($sql);
        } catch (\Exception $e) {
            throw new \Exception("Error al ejecutar la consulta: " . $e->getMessage());
        }
    }
     public function executeStatementByName($queryName, array $parameters = []) {
        $queryRecord = DB::table($this->table)
            ->where('NombreConsulta', $queryName)
            ->first();

        if (!$queryRecord) {
            throw new Exception("Consulta no encontrada: {$queryName}");
        }

        $sql = $queryRecord->SQL;

        try {
            return DB::statement($sql, $parameters);
        } catch (Exception $e) {
            throw new Exception("Error al ejecutar '{$queryName}': " . $e->getMessage());
        }
    }
}

