<?php
namespace App\Services;
use Illuminate\Support\Facades\Mail;

class NotificacionMail {

    public function enviarNotificacionEmail($accion, $movimiento, $destinatario){
        $queryExecutor = new DynamicQueryExecutor;
        if(is_string($destinatario)){
            $destinatario = [$destinatario];
        }

        $resultados = $queryExecutor->executeQueryByName('configura_mail_mensaje', [
            'Clasificacion'=>$movimiento
        ]);

        $asunto = ($accion == 'VALIDAR') ? $resultados[0]->AsuntoValidar : $resultados[0]->AsuntoAutorizar;
        $mensaje = ($accion == 'VALIDAR') ? $resultados[0]->MensajeValidar : $resultados[0]->MensajeAutorizar;

        Mail::raw($mensaje, function($message) use ($asunto, $destinatario){

            foreach($destinatario as $email){
                $message->to($email);
            }
            $message->subject($asunto);

        });

    }

}