<?php

namespace App\Services;

class PermisosService
{
    protected $queryExecutor;

    public function __construct()
    {
        $this->queryExecutor = new DynamicQueryExecutor();
    }

    /**
     * Obtener información completa del usuario asociado con roles y permisos
     */
    public function getPermisos($idRol)
    {
       $parametros = [
 
        'IdOpcion' => -1,
        'Acceder' => -1,
        'Insertar' => -1,
        'Editar' => -1,
        'Eliminar' => -1,
        'Importar' => -1,
        'Exportar' => -1,
        'Imprimir' => -1,
        'IdRol' => $idRol
       ];
         $resultado = $this->queryExecutor->executeQueryByName('asoc_roles_modulos', $parametros);
         //Filtrar solo los registros con el rol especificado
         return collect($resultado)->where('IdRol', $idRol);
    }
}
