<?php
namespace App\Services;
use Illuminate\Support\Facades\DB;

class generarCodigo{

    public function proveedor(){

        //obtiene el ultimo codigo registrado en bd
        $resultado = DB::select("SELECT MAX(Codigo) as cMax FROM master_proveedores;");
        $codigoActual = $resultado[0]->cMax;

        $numeroActual = (int) substr($codigoActual, 5); 

        $nuevoNumero = $numeroActual + 1;

        $nuevoCodigo = 'PROV-' . str_pad($nuevoNumero, 3, '0', STR_PAD_LEFT);

        return $nuevoCodigo;
    }

    public function proyecto(){

        //obtiene el ultimo codigo registrado en bd
        $resultado = DB::select("SELECT MAX(Codigo) as cMax FROM rd_proyecto;");
        $codigoActual = $resultado[0]->cMax;

        $numeroActual = (int) substr($codigoActual, 5); 

        $nuevoNumero = $numeroActual + 1;

        $nuevoCodigo = 'PROY-' . str_pad($nuevoNumero, 3, '0', STR_PAD_LEFT);

        return $nuevoCodigo;
    }

    public function componenteEquipo() {
        // Obtiene el último código registrado en la base de datos
        $resultado = DB::select("SELECT MAX(Codigo) as cMax FROM alm_insumos_componentes;");
        $codigoActual = $resultado[0]->cMax;
        $numeroActual = (int) substr($codigoActual, 1); 
        $nuevoNumero = $numeroActual + 1;
        // Formatea el nuevo código con ceros a la izquierda para mantener el formato C0001, C0002, etc.
        $nuevoCodigo = 'C' . str_pad($nuevoNumero, 4, '0', STR_PAD_LEFT);
    
        return $nuevoCodigo;
    }
    
    
}

