<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use InvalidArgumentException;

class generarId
{


    public function abonos($idPrestamo)
    {
        //veririca idPrestamo
        if (empty($idPrestamo)) {
            throw new InvalidArgumentException("El IdPrestamo es obligatorio.");
        }

        //obtener ultimo Id en teso_prestamos_pagos
        $sql = 'SELECT MAX(IdPrestamoPago) AS maxId FROM teso_prestamos_pagos WHERE IdPrestamo = ?';
        $result = DB::select($sql, [$idPrestamo]);

        // Obtener el nuevo ID de abono
        $nuevoId = isset($result[0]->maxId) ? intval($result[0]->maxId) + 1 : 1;

        return $nuevoId;
    }



    public function proveedor()
    {
        $resultado = DB::select("select MAX(IdProveedor) as idMax FROM master_proveedores;");
        $resultado = $resultado[0]->idMax;

        $nuevoId = $resultado + 1;

        return $nuevoId;
    }

    public function proyecto()
    {
        $resultado = DB::select("select MAX(IdProveedor) as idMax FROM rd_proyectos;");
        $resultado = $resultado[0]->idMax;

        $nuevoId = $resultado + 1;

        return $nuevoId;
    }

    public function componenteEquipo()
    {
        $resultado = DB::select("select MAX(IdComponente) as idMax FROM alm_insumos_componentes;");
        $resultado = $resultado[0]->idMax;

        $nuevoId = $resultado + 1;

        return $nuevoId;
    }

    public function tipoMto()
    {
        $resultado = DB::select("select MAX(IdClasificacionMtto) as idMax FROM mtto_clasificacion;");
        $resultado = $resultado[0]->idMax;

        $nuevoId = $resultado + 1;

        return $nuevoId;
    }

    public function frecuenciaMto()
    {
        $resultado = DB::select("select MAX(IdFrecuencia) as idMax FROM mtto_frecuencia;");
        $resultado = $resultado[0]->idMax;

        $nuevoId = $resultado + 1;

        return $nuevoId;
    }
}
