@extends('layouts.guest.guest')

@section('content')
    <div class="page-fade">

        <div class="container my-4">

            {{-- ===================== franja superior ===================== --}}
            <div class="row justify-content-center text-center">
                <div class="col-12 col-md-8 col-lg-6">
                    <div class="auth-strip text-light py-4 rounded-top">
                        <div class="row align-items-center g-3">

                            {{-- columna icono --}}
                            <div class="col-3 col-sm-2 d-flex justify-content-center">
                                <div class="icon-badge text-white" aria-hidden="true">
                                    <i class="fa-solid fa-unlock-keyhole"></i>
                                </div>
                            </div>

                            {{-- columna texto --}}
                            <div class="col-9 col-sm-10 text-start">
                                <h4 class="fw-bold mb-1 mb-sm-0">Recuperar contraseña</h4>
                                <p class="mb-0 opacity-75">
                                    Ingresa tu correo y te enviaremos un enlace para restablecerla.
                                </p>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            {{-- ===================== tarjeta ===================== --}}
            <div class="row justify-content-center">
                <div class="col-12 col-md-8 col-lg-6 d-flex">
                    <div class="card border-0 shadow-sm w-100 rounded-bottom">

                        {{-- estado de sesión (mensaje informativo) --}}
                        @if (session('status'))
                            <div class="alert alert-info mb-0 rounded-0 rounded-top">
                                {{ session('status') }}
                            </div>
                        @endif

                        <div class="card-body p-4 p-md-5">

                            <form method="POST" action="{{ route('password.email') }}" novalidate>
                                @csrf

                                {{-- email --}}
                                <div class="mb-4">
                                    <label for="email" class="form-label">Correo electrónico</label>
                                    <input id="email" type="email" name="email"
                                           class="form-control border-dark @error('email') is-invalid @enderror"
                                           value="{{ old('email') }}" required autofocus
                                           placeholder="tucorreo@dominio.com">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                {{-- enviar enlace --}}
                                <div class="d-grid mb-3">
                                    <button type="submit" class="btn btn-dark py-2">
                                        Enviar enlace de restablecimiento
                                    </button>
                                </div>

                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div>{{-- /.container --}}

    </div>{{-- /.page-fade --}}

    {{-- ===================== estilos ===================== --}}
    <style>
        :root {
            --dark-1: #0A0A2A;
            --dark-2: #13063E;
            --accent-1: #4a3b9e;
            --cyan-1: #33E1F7;
            --cyan-2: #00C2E8;
            --cyan-3: #0AA1C4;
            --ink-1: #001725;
        }

        /* animación de entrada */
        .page-fade { animation: fadeInPage .6s ease forwards; opacity: 0; }
        @keyframes fadeInPage { to { opacity: 1; } }

        /* franja superior */
        .auth-strip{
            background: linear-gradient(135deg, var(--dark-1) 0%, var(--dark-2) 60%, var(--accent-1) 100%);
            border-bottom: 1px solid rgba(255, 255, 255, .08);
        }

        /* icono badge */
        .icon-badge{
            height:44px; width:44px; display:grid; place-items:center;
            border-radius:12px; color:var(--ink-1);
            background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            box-shadow:0 6px 18px rgba(0,194,232,.35);
        }

        /* tarjeta */
        .card.rounded-bottom { border-radius: 0 0 .75rem .75rem; }
        .card.shadow-sm { transition: box-shadow .2s ease, transform .2s ease; }
        .card.shadow-sm:hover { box-shadow: 0 10px 24px rgba(0,0,0,.12); }

        /* inputs/botones en negro (consistencia con login/registro) */
        .form-control.border-dark {
            border-width: 1px !important;
            border-color: #000 !important;
        }
    </style>
@endsection
