{{--
    COMPONENTE: EMPTY PLATFORMS CARD

    Componente para mostrar cuando no hay plataformas disponibles
    Sin logos, mensaje claro y responsivo
--}}

<div class="empty-platforms-card">
    <div class="empty-platforms-card__container">
        {{-- Icono principal --}}
        <div class="empty-platforms-card__icon">
            <i class="fas fa-box-open"></i>
        </div>

        {{-- Título --}}
        <h3 class="empty-platforms-card__title">
            No hay versiones disponibles
        </h3>

        {{-- Descripción --}}
        <p class="empty-platforms-card__description">
            Actualmente no hay versiones de software disponibles para ninguna plataforma.
            Por favor, vuelve más tarde para consultar las actualizaciones.
        </p>

        {{-- Mensaje adicional --}}
        <div class="empty-platforms-card__info">
            <i class="fas fa-info-circle me-2"></i>
            <span>Si crees que esto es un error, contacta al administrador del sistema.</span>
        </div>
    </div>
</div>

<style>
    .empty-platforms-card {
        width: 100%;
        min-height: 400px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem 1rem;
    }

    .empty-platforms-card__container {
        max-width: 600px;
        width: 100%;
        text-align: center;
        background: rgba(255, 255, 255, 0.03);
        border: 2px dashed rgba(255, 255, 255, 0.15);
        border-radius: 20px;
        padding: 3rem 2rem;
        backdrop-filter: blur(10px);
        animation: fadeInScale 0.5s ease-out;
    }

    @keyframes fadeInScale {
        from {
            opacity: 0;
            transform: scale(0.95);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }

    .empty-platforms-card__icon {
        width: 120px;
        height: 120px;
        margin: 0 auto 2rem;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%);
        border-radius: 50%;
        border: 3px solid rgba(255, 255, 255, 0.2);
    }

    .empty-platforms-card__icon i {
        font-size: 4rem;
        color: rgba(255, 255, 255, 0.5);
        animation: float 3s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-10px);
        }
    }

    .empty-platforms-card__title {
        font-size: 1.75rem;
        font-weight: 700;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 1rem;
        line-height: 1.3;
    }

    .empty-platforms-card__description {
        font-size: 1.05rem;
        color: rgba(255, 255, 255, 0.6);
        margin-bottom: 2rem;
        line-height: 1.6;
    }

    .empty-platforms-card__info {
        display: inline-flex;
        align-items: center;
        padding: 0.875rem 1.5rem;
        background: rgba(59, 130, 246, 0.15);
        border: 1px solid rgba(59, 130, 246, 0.3);
        border-radius: 12px;
        color: rgba(147, 197, 253, 0.9);
        font-size: 0.95rem;
        gap: 0.5rem;
    }

    .empty-platforms-card__info i {
        font-size: 1.1rem;
        flex-shrink: 0;
    }

    /* Responsive */
    @media (max-width: 767.98px) {
        .empty-platforms-card {
            min-height: 350px;
            padding: 1.5rem 1rem;
        }

        .empty-platforms-card__container {
            padding: 2rem 1.5rem;
        }

        .empty-platforms-card__icon {
            width: 100px;
            height: 100px;
            margin-bottom: 1.5rem;
        }

        .empty-platforms-card__icon i {
            font-size: 3rem;
        }

        .empty-platforms-card__title {
            font-size: 1.5rem;
        }

        .empty-platforms-card__description {
            font-size: 1rem;
            margin-bottom: 1.5rem;
        }

        .empty-platforms-card__info {
            flex-direction: column;
            text-align: center;
            padding: 0.75rem 1.25rem;
            font-size: 0.9rem;
        }
    }

    @media (max-width: 575.98px) {
        .empty-platforms-card__container {
            padding: 1.5rem 1rem;
            border-radius: 16px;
        }

        .empty-platforms-card__icon {
            width: 80px;
            height: 80px;
        }

        .empty-platforms-card__icon i {
            font-size: 2.5rem;
        }

        .empty-platforms-card__title {
            font-size: 1.35rem;
        }

        .empty-platforms-card__description {
            font-size: 0.95rem;
        }
    }
</style>
