{{--
    COMPONENTE: MODAL DE HISTORIAL DE VERSIONES

    Modal que muestra el historial completo de versiones en formato timeline

    Props:
    @param string $uniqueId - ID único para el modal
    @param Collection $versions - Colección de versiones ordenadas
    @param Collection $filesPerVersion - Archivos agrupados por IdVersionApp
    @param string $platformName - Nombre de la plataforma
    @param Closure $safe - Función helper para valores seguros
    @param Closure $formatFechaCorta - Función para formatear fechas
--}}

<div class="modal fade version-history-modal" id="historyModal-{{ $uniqueId }}" tabindex="-1" aria-labelledby="historyModalLabel-{{ $uniqueId }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
        <div class="modal-content">
            {{-- HEADER --}}
            <div class="modal-header">
                <h5 class="modal-title" id="historyModalLabel-{{ $uniqueId }}">
                    <i class="fas fa-history me-2"></i>
                    Historial de Versiones - {{ $platformName }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            {{-- BODY --}}
            <div class="modal-body">
                @if($versions->count() > 0)
                    <div class="version-timeline">
                        @foreach($versions as $index => $version)
                            @php
                                $versionId = $safe($version, 'IdVersionApp', $index);
                                $versionNumber = $safe($version, 'SVersion', '1.0.0');
                                $versionDate = $safe($version, 'DFecha', now());
                                $versionSO = $safe($version, 'SVersionSO', 'Compatible');
                                $size = $safe($version, 'STamanio', '-');
                                $summary = $safe($version, 'SResumenVersion', '');
                                $improvements = $safe($version, 'SMejorasVersion', '');
                                $requirements = $safe($version, 'SRequisitos', '');
                                $isLatest = $index === 0;

                                // Obtener archivos de esta versión
                                $files = $filesPerVersion->get($versionId, collect());
                                $downloadUrl = $files->first() ? $safe($files->first(), 'URL_Ejecutable', '') : '';
                                $scriptUrl = $files->first() ? $safe($files->first(), 'URL_Scripts', '') : '';
                                $pdfUrl = $safe($version, 'URL_PDF', '');
                            @endphp

                            <div class="version-timeline-item" style="animation-delay: {{ $index * 0.1 }}s;">
                                {{-- Marker --}}
                                <div class="version-timeline-marker {{ $isLatest ? 'latest' : '' }}"></div>

                                {{-- Content --}}
                                <div class="version-timeline-content">
                                    {{-- Header --}}
                                    <div class="version-timeline-header">
                                        <div>
                                            <span class="version-timeline-version">
                                                v{{ $versionNumber }}
                                                @if($isLatest)
                                                    <span class="badge bg-success ms-2">Más reciente</span>
                                                @endif
                                            </span>
                                            <div class="version-timeline-date mt-1">
                                                <i class="fas fa-calendar-alt me-1"></i>
                                                {{ $formatFechaCorta($versionDate) }}
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            @if($size !== '-' && $size !== 'No disponible')
                                            <div class="badge bg-secondary">
                                                <i class="fas fa-file-archive me-1"></i>{{ $size }}
                                            </div>
                                            @endif
                                        </div>
                                    </div>

                                    {{-- Meta Info --}}
                                    <div class="mb-2 text-muted small">
                                        <i class="fas fa-desktop me-1"></i>{{ $versionSO }}
                                    </div>

                                    {{-- Body --}}
                                    <div class="version-timeline-body">
                                        @if($summary !== '' && $summary !== 'No disponible')
                                        <div class="mb-2">
                                            <strong class="text-card-brand">Resumen:</strong>
                                            <p class="mb-1">{{ $summary }}</p>
                                        </div>
                                        @endif

                                        @if($improvements !== '' && $improvements !== 'No disponible' && $improvements !== '-1')
                                        <div class="mb-2">
                                            <strong class="text-card-brand">Mejoras:</strong>
                                            <div class="mt-1">
                                                {!! nl2br(e($improvements)) !!}
                                            </div>
                                        </div>
                                        @endif

                                        @if($requirements !== '' && $requirements !== 'No disponible' && $requirements !== 'Sin requisitos especificados')
                                        <div class="mb-2">
                                            <strong class="text-card-brand">Requisitos:</strong>
                                            <p class="mb-1 small">{{ $requirements }}</p>
                                        </div>
                                        @endif
                                    </div>

                                    {{-- Botones --}}
                                    <div class="d-flex flex-wrap gap-2 mt-3">
                                        @if($downloadUrl !== '' && $downloadUrl !== 'No disponible' && $downloadUrl !== '-1')
                                        <a href="{{ $downloadUrl }}" class="btn btn-sm btn-card-brand" target="_blank">
                                            <i class="fas fa-download me-1"></i>Descargar
                                        </a>
                                        @endif

                                        @if($scriptUrl !== '' && $scriptUrl !== 'No disponible' && $scriptUrl !== '-1')
                                        <a href="{{ $scriptUrl }}" class="btn btn-sm btn-outline-card-brand" target="_blank">
                                            <i class="fas fa-code me-1"></i>Script
                                        </a>
                                        @endif

                                        @if($pdfUrl !== '' && $pdfUrl !== 'No disponible' && $pdfUrl !== '-1')
                                        <a href="{{ $pdfUrl }}" class="btn btn-sm btn-outline-card-brand" target="_blank">
                                            <i class="fas fa-file-pdf me-1"></i>PDF
                                        </a>
                                        @endif

                                        @if($improvements !== '' && $improvements !== 'No disponible' && $improvements !== '-1')
                                        <button
                                            type="button"
                                            class="btn btn-sm btn-outline-secondary btn-details-toggle"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#details-{{ $uniqueId }}-{{ $versionId }}"
                                            aria-expanded="false"
                                            aria-controls="details-{{ $uniqueId }}-{{ $versionId }}">
                                            <i class="fas fa-info-circle me-1"></i>
                                            Detalles
                                        </button>
                                        @endif
                                    </div>

                                    {{-- Detalles colapsables --}}
                                    @if($improvements !== '' && $improvements !== 'No disponible' && $improvements !== '-1')
                                    <div class="collapse mt-3" id="details-{{ $uniqueId }}-{{ $versionId }}">
                                        <div class="card card-body bg-light border-0">
                                            <h6 class="text-card-brand fw-bold mb-2">
                                                <i class="fas fa-list-check me-2"></i>Detalles completos
                                            </h6>
                                            <div class="small">
                                                {!! nl2br(e($improvements)) !!}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>

                    {{-- Resumen estadístico --}}
                    <div class="alert alert-info mt-4 mb-0" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-info-circle fa-2x me-3"></i>
                            <div>
                                <strong>Total de versiones disponibles: {{ $versions->count() }}</strong>
                                <div class="small mt-1">
                                    Última actualización: {{ $formatFechaCorta($versions->first() ? $safe($versions->first(), 'DFecha', now()) : now()) }}
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted">No hay versiones disponibles para mostrar.</p>
                    </div>
                @endif
            </div>

            {{-- FOOTER --}}
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>Cerrar
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    /* Estilos adicionales específicos del modal si son necesarios */
    .version-history-modal .modal-body {
        max-height: 70vh;
    }

    .version-history-modal .version-timeline-content {
        cursor: default;
    }

    .version-history-modal .version-timeline-body p {
        margin-bottom: 0.5rem;
        line-height: 1.5;
    }

    .version-history-modal .badge {
        font-weight: 500;
    }

    /* Animación de entrada para los items del timeline */
    .version-timeline-item {
        opacity: 0;
        animation: slideInTimeline 0.5s ease forwards;
    }

    @keyframes slideInTimeline {
        from {
            opacity: 0;
            transform: translateX(-20px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    /* Mejoras para el colapso de detalles */
    .collapse .card-body {
        max-height: 300px;
        overflow-y: auto;
    }

    .collapse .card-body::-webkit-scrollbar {
        width: 6px;
    }

    .collapse .card-body::-webkit-scrollbar-track {
        background: #e9ecef;
        border-radius: 3px;
    }

    .collapse .card-body::-webkit-scrollbar-thumb {
        background: #adb5bd;
        border-radius: 3px;
    }

    /* Responsivo */
    @media (max-width: 767.98px) {
        .version-timeline {
            padding-left: 1.5rem;
        }

        .version-timeline::before {
            left: 0.375rem;
        }

        .version-timeline-marker {
            left: -1.375rem;
        }

        .version-timeline-marker.latest {
            left: -1.5rem;
        }

        .version-timeline-header {
            flex-direction: column;
            gap: 0.5rem;
        }

        .version-timeline-header > div:last-child {
            text-align: left !important;
        }
    }
</style>
