@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container mt-5 d-flex justify-content-center">
    <div class="col-md-11"> 
        <h2 class="mb-5 text-white text-center fw-bold">Registrar nueva versión del proyecto</h2>

        {{-- Mensajes --}}
        @if(session('success'))
            <div class="alert alert-success text-center">{{ session('success') }}</div>
        @endif

        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Formulario principal --}}
        <form action="{{ route('admin_proyectos_version_insertar') }}" method="POST" enctype="multipart/form-data">
        @csrf

            <div class="row g-4">
                {{-- Columna Izquierda --}}
                <div class="col-md-6 pe-md-4 border-end border-light-subtle">
                   <div class="mb-4">
                        <label for="proyecto" class="form-label label-serio">Proyecto seleccionado</label>
                        <input type="text" class="form-control input-serio" value="{{ $proyecto->SNombreProyecto }}" readonly>
                        <input type="hidden" name="IdProyecto" value="{{ $proyecto->IdProyecto }}">
                    </div>


                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="version" class="form-label label-serio">Versión</label>
                            <input type="text" name="version" id="version" class="form-control input-serio" placeholder="Ej. 1.0.3" required>
                        </div>
                        <div class="col-md-6">
                            <label for="so" class="form-label label-serio">Sistema Operativo</label>
                                <select name="IdSO" id="so" class="form-select input-serio" required>
                                    <option value="">-- Selecciona --</option>
                                    @foreach($sistemasOperativos as $so)
                                        <option value="{{ $so->IdSO }}">{{ $so->SNombre }}</option>
                                     @endforeach
                                </select>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="codigo" class="form-label label-serio">Código interno</label>
                            <input type="text" name="SCodigo" id="codigo" class="form-control input-serio" placeholder="Ej. ACT-001">
                        </div>
                        <div class="col-md-6">
                            <label for="activo" class="form-label label-serio">Activo</label>
                            <select name="EActivo" id="activo" class="form-select input-serio">
                                <option value="Si">Sí</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>

                    {{-- Textareas de descripción --}}
                    @foreach([
                        ['id' => 'descripcion', 'label' => 'Descripción', 'placeholder' => 'Describe brevemente la versión...'],
                        ['id' => 'resumen', 'label' => 'Resumen de la versión', 'placeholder' => 'Breve resumen de esta versión...'],
                        ['id' => 'mejoras', 'label' => 'Mejoras de la versión', 'placeholder' => 'Lista de mejoras o cambios importantes...'],
                        ['id' => 'requisitos', 'label' => 'Requisitos', 'placeholder' => 'Indica los requisitos mínimos...'],
                        ['id' => 'recomendaciones', 'label' => 'Recomendaciones', 'placeholder' => 'Consejos o recomendaciones para el usuario...']
                    ] as $textarea)
                    <div class="mb-4">
                        <label for="{{ $textarea['id'] }}" class="form-label label-serio">{{ $textarea['label'] }}</label>
                        <textarea name="{{ $textarea['id'] }}" id="{{ $textarea['id'] }}" rows="3" class="form-control input-serio" placeholder="{{ $textarea['placeholder'] }}" required></textarea>
                    </div>
                    @endforeach

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="version_so" class="form-label label-serio">Versión del Sistema Operativo</label>
                            <input type="text" name="version_so" id="version_so" class="form-control input-serio" placeholder="Ej. Windows 11, Android 14" required>
                        </div>
                        <div class="col-md-6">
                            <label for="tamano" class="form-label label-serio">Tamaño</label>
                            <input type="text" name="tamano" id="tamano" class="form-control input-serio" placeholder="Ej. 25 MB" required>
                        </div>
                    </div>
                </div>

                {{-- Columna Derecha --}}
                <div class="col-md-6 ps-md-4">
                    <h5 class="text-white mb-3 mt-1 fw-semibold">Documentación</h5>

                    <div class="mb-4">
                        <label for="documentacion" class="form-label label-serio">Subir documentación (PDF)</label>
                        <input type="file" name="documentacion" id="documentacion" class="form-control input-serio" accept=".pdf" required>
                    </div>

                    <div class="mb-4">
                        <label for="url_video" class="form-label label-serio">URL del video</label>
                        <input type="url" name="url_video" id="url_video" class="form-control input-serio" placeholder="https://ejemplo.com/video" required>
                    </div>

                    <h5 class="text-white mb-3 mt-4 fw-semibold">Archivos de versión</h5>

                    <div class="mb-4">
                        <label for="ejecutable" class="form-label label-serio">Subir ejecutable (.exe / .zip)</label>
                        <input type="file" name="ejecutable" id="ejecutable" class="form-control input-serio" accept=".exe,.zip" required>
                    </div>

                    <div class="mb-4">
                        <label for="reporte" class="form-label label-serio">Subir reporte</label>
                        <input type="file" name="reporte" id="reporte" class="form-control input-serio" accept=".pdf,.docx" required>
                    </div>

                    <div class="mb-4">
                        <label for="script" class="form-label label-serio">Subir script (PDF)</label>
                        <input type="file" name="script" id="script" class="form-control input-serio" accept=".pdf" required>
                    </div>

                    <div class="mb-4">
                        <label for="url_tienda" class="form-label label-serio">URL tienda</label>
                        <input type="url" name="url_tienda" id="url_tienda" class="form-control input-serio" placeholder="https://ejemplo.com/tienda" required>
                    </div>
                </div>
            </div>

            {{-- Botones centrados --}}
            <div class="text-center mt-4">
                <a href="{{ route('admin_proyectos') }}" class="btn btn-secondary me-3 px-4 py-2">Volver</a>
                <button type="submit" class="btn btn-serio px-5 py-2 fw-semibold">Guardar versión</button>
            </div>

            {{-- Archivo cargado --}}
            @if(session('file_url'))
                <div class="alert alert-info mt-4 text-center">
                    <strong>Archivo cargado correctamente:</strong><br>
                    <a href="{{ session('file_url') }}" target="_blank" class="text-light">
                        {{ session('file_url') }}
                    </a>
                </div>
            @endif
        </form>
    </div>
</div>
@endsection

@push('styles')
<style>
    :root {
    --dark-1: #0A0A2A;
    --dark-2: #13063E;
    --accent-1: #4a3b9e;
    --cyan-1: #73ecf4;
    --cyan-2: #61e2ea;
    --cyan-3: #3eb5bd;
    --ink-1: #001725;
}
.formulario-serio {
    background: #3eb5bd;
    padding: 2.5rem;
    border-radius: 0.75rem;
    box-shadow: 0 4px 12px rgba(0, 194, 232, .3);
    border: 1px solid #4b5563;
    color: #e7ebf0;
}

.label-serio {
    font-weight: 600;
    color: #e7ebf0;
}
.input-serio {
    background-color: #2e3440;
    border: 1.5px solid #4b5563;
    color: #e7ebf0;
    border-radius: 6px;
    padding: 0.5rem 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}
.input-serio:focus {
    border-color: #2563eb;
    box-shadow: 0 0 6px #2563eb;
    background-color: #24314a;
}
.btn-serio {
    background: #2563eb;
    color: #fff;
    font-weight: 600;
    border: none;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(37,99,235,0.5);
    transition: 0.3s;
}
.btn-serio:hover {
    background: #1e40af;
    box-shadow: 0 4px 14px rgba(30,64,175,0.7);
}
textarea.input-serio {
    min-height: 90px;
    max-height: 150px;
}
/* Color blanco para los placeholders */
.input-serio::placeholder,
textarea.input-serio::placeholder {
    color: #e5e7eb; /* blanco suave */
    opacity: 1; /* asegura que no se vea translúcido */
}

</style>
@endpush
