@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container mt-4 text-white">
    <h2>Subir comprobante</h2>

    {{-- Mensaje de éxito --}}
    @if(session('success'))
        <div class="alert alert-success mt-2">{{ session('success') }}</div>
    @endif

    {{-- Errores --}}
    @error('ComprobanteArchivo')
        <div class="alert alert-danger mt-2">{{ $message }}</div>
    @enderror

    {{-- Formulario --}}
    <form action="{{ route('clienteVistaProyecto') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="form-group col-md-6 mt-3">
            <label for="ComprobanteArchivo" class="form-label">Comprobante</label>
            <input type="file" class="form-control" name="ComprobanteArchivo" accept=".pdf,.exe,.zip" required>
        </div>

        <button type="submit" class="btn btn-primary mt-3">Subir</button>
    </form>

    {{-- ✅ Mostrar enlace del archivo subido --}}
    @if(session('file_url'))
        <div class="mt-4">
            <h5>Archivo subido:</h5>
            <a href="{{ session('file_url') }}" target="_blank" class="btn btn-success">
                Descargar Comprobante
            </a>
            <p class="mt-2">
                <small>URL: <a href="{{ session('file_url') }}" target="_blank">{{ session('file_url') }}</a></small>
            </p>
        </div>
    @endif
</div>
@endsection
