<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Noil') }}</title>

    <!-- Icono -->
    <link rel="icon" href="{{ asset('img/noil.png') }}" type="image/png">

    <!-- Link de estilo CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="d-flex flex-column min-vh-100" style="background-color: #13063E">


    <!-- Navegador -->
     @include('layouts.guest.partials.navbar')

    <!-- Contenido Main -->
    <main class="flex-fill">
        @yield('content')
    </main>

    <!-- Footer -->
    @include('layouts.guest.partials.footer')


    <!-- Scripts -->

    <!-- Script para estilo -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-j1CDi7MgGQ12Z7Qab0qlWQ/Qqz24Gc6BM0thvEMVjHnfYGF0rmFCozFSxQBxwHKO" crossorigin="anonymous">
    </script>

    <!-- Script para graficos -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Script para alertas -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</body>

</html>
