<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil de Usuario</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 20px;
        }
        
        .profile-container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            padding: 2rem;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .profile-header {
            text-align: center;
            margin-bottom: 2rem;
            border-bottom: 1px solid #eee;
            padding-bottom: 1rem;
        }
        
        .profile-header h2 {
            color: #333;
            font-weight: 600;
        }
        
        .form-control:focus {
            border-color: #1e88e5;
            box-shadow: 0 0 0 0.2rem rgba(30, 136, 229, 0.25);
        }
        
        .btn-primary {
            background-color: #1e88e5;
            border-color: #1e88e5;
        }
        
        .btn-primary:hover {
            background-color: #1976d2;
            border-color: #1976d2;
        }
        
        .profile-field {
            margin-bottom: 1.5rem;
        }
        
        .profile-field label {
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .password-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }
        
        .password-modal-content {
            background-color: white;
            border-radius: 15px;
            padding: 2rem;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        
        .password-match-error {
            color: #dc3545;
            font-size: 0.875rem;
            display: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="profile-container">
            <div class="profile-header">
                <h2>Perfil de Usuario</h2>
                <p class="text-muted">Gestiona tu información personal</p>
            </div>

            <!-- Mostrar errores -->
            @if($errors->any())
                <div class="alert alert-danger error-alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(session('status'))
                <div class="alert alert-success error-alert">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('editarPerfil.update') }}">
                @csrf
                @method('PUT')

                <div class="profile-field">
                    <label for="SUsuario" class="form-label">Nombre de Usuario</label>
                    <input type="text" 
                           class="form-control @error('SUsuario') is-invalid @enderror" 
                           id="SUsuario" 
                           name="SUsuario" 
                           value="{{ old('SUsuario', $user->SUsuario) }}" 
                           required>
                    @error('SUsuario')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="SNombre" class="form-label">Nombre Completo</label>
                    <input type="text" 
                           class="form-control @error('SNombre') is-invalid @enderror" 
                           id="SNombre" 
                           name="SNombre" 
                           value="{{ old('SNombre', $user->SNombre) }}" 
                           required>
                    @error('SNombre')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="SMail" class="form-label">Correo Electrónico</label>
                    <input type="email" 
                           class="form-control @error('SMail') is-invalid @enderror" 
                           id="SMail" 
                           name="SMail" 
                           value="{{ old('SMail', $user->SMail) }}" 
                           required>
                    @error('SMail')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="STelefono" class="form-label">Teléfono</label>
                    <input type="tel" 
                           class="form-control @error('STelefono') is-invalid @enderror" 
                           id="STelefono" 
                           name="STelefono" 
                           value="{{ old('STelefono', $user->STelefono) }}">
                    @error('STelefono')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="IdDepartamento" class="form-label">Departamento</label>
                    <select class="form-select @error('IdDepartamento') is-invalid @enderror" 
                            id="IdDepartamento" 
                            name="IdDepartamento" 
                            required>
                        <option value="">Selecciona un departamento</option>
                        @foreach($departamentos as $departamento)
                            <option value="{{ $departamento->id }}" 
                                    {{ old('IdDepartamento', $user->IdDepartamento) == $departamento->id ? 'selected' : '' }}>
                                {{ $departamento->nombre }}
                            </option>
                        @endforeach
                    </select>
                    @error('IdDepartamento')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="IdPuesto" class="form-label">Puesto</label>
                    <select class="form-select @error('IdPuesto') is-invalid @enderror" 
                            id="IdPuesto" 
                            name="IdPuesto" 
                            required>
                        <option value="">Selecciona un puesto</option>
                        @foreach($puestos as $puesto)
                            <option value="{{ $puesto->id }}" 
                                    {{ old('IdPuesto', $user->IdPuesto) == $puesto->id ? 'selected' : '' }}>
                                {{ $puesto->nombre }}
                            </option>
                        @endforeach
                    </select>
                    @error('IdPuesto')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label class="form-label">Contraseña</label>
                    <div>
                        <button type="button" class="btn btn-outline-primary" id="changePasswordBtn">
                            Cambiar Contraseña
                        </button>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ url('/dashboard') }}" class="btn btn-secondary">Cancelar</a>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para cambiar contraseña -->
    <div class="password-modal" id="passwordModal">
        <div class="password-modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cambiar Contraseña</h5>
                <button type="button" class="btn-close" id="closePasswordModal"></button>
            </div>
            <div class="modal-body">
                <form id="passwordForm">
                    @csrf
                    <div class="mb-3">
                        <label for="newPassword" class="form-label">Nueva Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="newPassword" 
                               name="newPassword" 
                               required minlength="8">
                        <div class="form-text">La contraseña debe tener al menos 8 caracteres.</div>
                    </div>
                    <div class="mb-3">
                        <label for="confirmPassword" class="form-label">Confirmar Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="confirmPassword" 
                               name="newPassword_confirmation" 
                               required>
                        <div class="password-match-error" id="passwordMatchError">
                            Las contraseñas no coinciden
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancelPasswordChange">Cancelar</button>
                <button type="button" class="btn btn-primary" id="savePassword">Guardar</button>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const changePasswordBtn = document.getElementById('changePasswordBtn');
            const passwordModal = document.getElementById('passwordModal');
            const closePasswordModal = document.getElementById('closePasswordModal');
            const cancelPasswordChange = document.getElementById('cancelPasswordChange');
            const savePassword = document.getElementById('savePassword');
            const newPassword = document.getElementById('newPassword');
            const confirmPassword = document.getElementById('confirmPassword');
            const passwordMatchError = document.getElementById('passwordMatchError');
            
            // Abrir modal para cambiar contraseña
            changePasswordBtn.addEventListener('click', function() {
                passwordModal.style.display = 'flex';
            });
            
            // Cerrar modal
            function closeModal() {
                passwordModal.style.display = 'none';
                // Limpiar formulario
                document.getElementById('passwordForm').reset();
                passwordMatchError.style.display = 'none';
            }
            
            closePasswordModal.addEventListener('click', closeModal);
            cancelPasswordChange.addEventListener('click', closeModal);
            
            // Validar que las contraseñas coincidan
            function validatePasswords() {
                if (newPassword.value !== confirmPassword.value) {
                    passwordMatchError.style.display = 'block';
                    confirmPassword.classList.add('is-invalid');
                    return false;
                } else {
                    passwordMatchError.style.display = 'none';
                    confirmPassword.classList.remove('is-invalid');
                    return true;
                }
            }
            
            confirmPassword.addEventListener('input', validatePasswords);
            newPassword.addEventListener('input', validatePasswords);
            
            // Guardar nueva contraseña
            savePassword.addEventListener('click', function() {
                if (validatePasswords() && newPassword.value.length >= 8) {
                    // Enviar la solicitud al servidor
                    const formData = new FormData(document.getElementById('passwordForm'));
                    
                    fetch('{{ route("editarPerfil.password") }}', {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                            closeModal();
                        } else {
                            alert('Error al cambiar la contraseña');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('Error al cambiar la contraseña');
                    });
                } else if (newPassword.value.length < 8) {
                    alert('La contraseña debe tener al menos 8 caracteres');
                }
            });
        });
    </script>
</body>
</html>