@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container-fluid mt-4">
    {{-- Título principal --}}
    <h2 class="mb-4 text-center text-white fw-semibold">Panel de Administración</h2>

    {{-- Tarjetas resumen --}}
    <div class="row g-4 mb-5">
        <div class="col-md-4">
            <div class="card shadow-lg border-0 rounded-4" style="background-color:#0A0A2A;">
                <div class="card-body text-white d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="fw-semibold mb-1">Usuarios Registrados</h5>
                        <h3 class="fw-bold mb-0">245</h3>
                    </div>
                    <div class="icon-container bg-gradient-info">
                        <i class="fas fa-users fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-lg border-0 rounded-4" style="background-color:#0A0A2A;">
                <div class="card-body text-white d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="fw-semibold mb-1">Proyectos Activos</h5>
                        <h3 class="fw-bold mb-0">18</h3>
                    </div>
                    <div class="icon-container bg-gradient-warning">
                        <i class="fas fa-briefcase fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-lg border-0 rounded-4" style="background-color:#0A0A2A;">
                <div class="card-body text-white d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="fw-semibold mb-1">Reportes Pendientes</h5>
                        <h3 class="fw-bold mb-0">5</h3>
                    </div>
                    <div class="icon-container bg-gradient-danger">
                        <i class="fas fa-exclamation-circle fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Tabla de usuarios --}}
    <div class="card border-0 shadow-lg rounded-5" style="background-color: #0A0A2A;">
        <div class="card-header text-white d-flex justify-content-between align-items-center rounded-top-4">
            <h5 class="mb-0"><i class="fas fa-users me-2"></i>Gestión de Usuarios</h5>
            <button class="btn btn-light btn-sm text-white fw-semibold rounded-2"
                style="background-color: #4a3b9e; border: none;">
                <i class="fas fa-user-plus me-1"></i>Nuevo Usuario
            </button>
        </div>
        <div class="card-body bg-light rounded-bottom-5">
            <table class="table table-hover align-middle text-center">
                <thead style="background-color:#0A0A2A;" class="text-white">
                    <tr>
                        <th>#</th>
                        <th>NOMBRE</th>
                        <th>CORREO</th>
                        <th>ROL</th>
                        <th>ACCIONES</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>Juan Pérez</td>
                        <td>juan@example.com</td>
                        <td>Admin</td>
                        <td>
                            <button class="btn btn-sm btn-info-gradient me-1">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-warning-gradient me-1">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger-gradient">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>María López</td>
                        <td>maria@example.com</td>
                        <td>Usuario</td>
                        <td>
                            <button class="btn btn-sm btn-info-gradient me-1">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-warning-gradient me-1">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger-gradient">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- Estilos --}}
<style>
    .icon-container {
        width: 50px;
        height: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
        border-radius: 10px;
    }

    .bg-gradient-info {
        background: linear-gradient(135deg, #73ecf4, #3eb5bd);
        color: #000;
    }

    .bg-gradient-warning {
        background: linear-gradient(135deg, #facc15, #f59e0b);
        color: #000;
    }

    .bg-gradient-danger {
        background: linear-gradient(135deg, #ef4444, #b91c1c);
        color: #fff;
    }

    .btn-info-gradient {
        background: linear-gradient(135deg, #73ecf4, #3eb5bd);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-warning-gradient {
        background: linear-gradient(135deg, #facc15, #f59e0b);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-danger-gradient {
        background: linear-gradient(135deg, #ef4444, #b91c1c);
        color: white;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-info-gradient:hover,
    .btn-warning-gradient:hover,
    .btn-danger-gradient:hover {
        transform: translateY(-1px);
        opacity: 0.9;
    }

    table thead th {
        color: #fff !important;
        border: none;
    }

    table tbody td {
        vertical-align: middle;
    }
</style>
@endsection
