@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container-fluid mt-4">
    {{-- Título principal --}}
    <h2 class="mb-4 text-center text-white fw-semibold">Gestión de Proyectos</h2>

    {{-- Mensajes de éxito o error --}}
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    {{-- Tarjeta principal --}}
    <div class="card border-0 shadow-lg rounded-5" style="background-color: #0A0A2A;">
        <div class="card-header text-white d-flex justify-content-between align-items-center rounded-top-4">
            <h5 class="mb-0"><i class="fas fa-briefcase me-2"></i>Lista de Proyectos</h5>

            <div class="d-flex gap-2">
                {{-- Botón para abrir modal --}}
                <button id="btnNuevoProyecto" class="btn btn-sm text-white fw-semibold rounded-2"
                    style="background-color: #4a3b9e; border: none;"
                    data-bs-toggle="modal" data-bs-target="#proyectoModal">
                    <i class="fas fa-plus me-1"></i>Nuevo Proyecto
                </button>
            </div>
        </div>

       <div class="card-body bg-light rounded-bottom-5">
        <table class="table table-hover table-striped align-middle text-center">

        <thead style="background-color:#1a1a40;">
            <tr class="text-white">
                <th>ID</th>
                <th>Nombre</th>
                <th>Descripción</th>
                <th>Activo</th>
                <th>Visible</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($resultados as $proyecto)
                <tr>
                    <td>{{ $proyecto->IdProyecto }}</td>
                    <td>{{ $proyecto->SNombreProyecto }}</td>
                    <td>{{ $proyecto->SDescripcion }}</td>
                    <td>
                        @if($proyecto->EActivo == 'Si')
                            <span class="badge bg-success">Sí</span>
                        @else
                            <span class="badge bg-danger">No</span>
                        @endif
                    </td>
                    <td>
                        @if($proyecto->EVisible == 'Si')
                            <span class="badge bg-primary">Sí</span>
                        @else
                            <span class="badge bg-secondary">No</span>
                        @endif
                    </td>
                    <td>
                        <div class="d-flex flex-column align-items-center gap-2">
                           <a href="{{ route('admin_proyectos_ver', $proyecto->IdProyecto) }}" 
                                class="btn btn-sm btn-info-gradient">
                                <i class="fas fa-eye"></i>
                            </a>
                            <button class="btn btn-sm btn-warning-gradient btnEditarProyecto"
                                data-id="{{ $proyecto->IdProyecto }}"
                                data-nombre="{{ $proyecto->SNombreProyecto }}"
                                data-descripcion="{{ $proyecto->SDescripcion }}"
                                data-imagen="{{ $proyecto->URL_imagen }}"
                                data-activo="{{ $proyecto->EActivo }}"
                                data-visible="{{ $proyecto->EVisible }}">
                                <i class="fas fa-edit"></i>
                            </button>
                            <a href="{{ route('adminCargarProyecto') }}" class="btn btn-sm btn-success fw-semibold rounded-2">
                                <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">No hay proyectos registrados</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

    </div>
</div>

{{-- Modal: Crear o Editar proyecto --}}
<div class="modal fade" id="proyectoModal" tabindex="-1" aria-labelledby="proyectoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white rounded-4">
            <div class="modal-header border-0">
                <h5 class="modal-title fw-semibold" id="modalTitulo">
                    <i class="fas fa-plus-circle me-2"></i>Agregar Nuevo Proyecto
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <form id="formProyecto" method="POST" action="{{ route('admin_proyectos_insertar') }}">
                @csrf
                <input type="hidden" name="IdProyecto" id="IdProyecto">

                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nombre del Proyecto</label>
                        <input type="text" name="SNombreProyecto" id="SNombreProyecto" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descripción</label>
                        <textarea name="SDescripcion" id="SDescripcion" class="form-control"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">URL de Imagen</label>
                        <input type="text" name="URL_Imagen" id="URL_Imagen" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Activo</label>
                        <select name="EActivo" id="EActivo" class="form-control">
                            <option value="Si">Sí</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Visible</label>
                        <select name="EVisible" id="EVisible" class="form-control">
                            <option value="Si">Sí</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                </div>

                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" id="btnGuardar" class="btn btn-success">Guardar Proyecto</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Estilos --}}
<style>
    .btn-info-gradient {
        background: linear-gradient(135deg, #73ecf4, #3eb5bd);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-warning-gradient {
        background: linear-gradient(135deg, #facc15, #f59e0b);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-danger-gradient {
        background: linear-gradient(135deg, #ef4444, #b91c1c);
        color: white;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }

    .btn-info-gradient:hover,
    .btn-warning-gradient:hover,
    .btn-danger-gradient:hover {
        transform: translateY(-1px);
        opacity: 0.9;
    }

    thead th {
        color: #131212 !important;
    }

    .badge {
        font-size: 0.85rem;
        padding: 6px 10px;
        border-radius: 8px;
    }
</style>

{{-- Script para editar proyectos --}}
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modal = new bootstrap.Modal(document.getElementById('proyectoModal'));
        const form = document.getElementById('formProyecto');
        const titulo = document.getElementById('modalTitulo');
        const btnGuardar = document.getElementById('btnGuardar');

        // Nuevo proyecto
        document.getElementById('btnNuevoProyecto').addEventListener('click', function () {
            form.reset();
            form.action = "{{ route('admin_proyectos_insertar') }}";
            titulo.innerHTML = '<i class="fas fa-plus-circle me-2"></i>Agregar Nuevo Proyecto';
            btnGuardar.textContent = 'Guardar Proyecto';
            document.getElementById('IdProyecto').value = '';
        });

        // Editar proyecto
        document.querySelectorAll('.btnEditarProyecto').forEach(boton => {
            boton.addEventListener('click', function () {
                const id = this.dataset.id;
                const nombre = this.dataset.nombre;
                const descripcion = this.dataset.descripcion;
                const imagen = this.dataset.imagen;
                const activo = this.dataset.activo;
                const visible = this.dataset.visible;

                form.action = `/admin/proyectos/editar/${id}`;
                document.getElementById('IdProyecto').value = id;
                document.getElementById('SNombreProyecto').value = nombre;
                document.getElementById('SDescripcion').value = descripcion;
                document.getElementById('URL_Imagen').value = imagen;
                document.getElementById('EActivo').value = activo;
                document.getElementById('EVisible').value = visible;

                titulo.innerHTML = '<i class="fas fa-edit me-2"></i>Editar Proyecto';
                btnGuardar.textContent = 'Actualizar Proyecto';

                modal.show();
            });
        });
    });
</script>
@endsection
