@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container mt-5">
    <h2 class="mb-4 text-center text-white">Gestión de Usuarios</h2>

    {{-- Tabla de usuarios --}}
       <div class="card border-0 shadow-lg bg-light rounded-5 "  style="background-color: #0A0A2A;" >
        <div  style="background-color: #0A0A2A;" class="card-header  text-white d-flex justify-content-between align-items-center rounded-top-4">
            <h5 class="mb-0"><i class="fas fa-users me-2"></i>Lista de Usuarios</h5>
            
            <button class="btn btn-light btn-sm text-white fw-semibold rounded-2 "  style="background-color: #4a3b9e; border: none;">
                <i class="fas fa-user-plus me-1"></i>Nuevo Usuario
            </button>
        </div>
        <div class="card-body ">
            <div id="tablaUsuarios">
                <table class="table table-hover align-middle text-center">
                    <thead style="background-color: #0A0A2A;">
                        <tr>
                            <th>#</th>
                            <th>NOMBRE</th>
                            <th>CORREO</th>
                            <th>ROL</th>
                            <th>ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- Ejemplo de filas sin lógica --}}
                        <tr>
                            <td>1</td>
                            <td>Juan Pérez</td>
                            <td>juan@example.com</td>
                            <td>Admin</td>
                            <td>
                                <button class="btn btn-sm  me- icon-badge-sm" data-bs-toggle="modal" data-bs-target="#infoUsuarioModal">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-sm  me-1 icon-badge-sm">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm  icon-badge-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>María López</td>
                            <td>maria@example.com</td>
                            <td>Usuario</td>
                            <td>
                                <button class="btn btn-sm btn-info-gradient me-1" data-bs-toggle="modal" data-bs-target="#infoUsuarioModal">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning-gradient me-1">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger-gradient">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>    
            {{-- Paginación (ficticia) --}}
            <nav>
                <ul class="pagination justify-content-center">
                    <li class="page-item disabled">
                        <a class="page-link" href="#">Anterior</a>
                    </li>
                    <li class="page-item active">
                        <a class="page-link" href="#">1</a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" href="#">2</a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" href="#" style="text-color: #0A0A2A;">Siguiente</a>
                    </li>
                </ul>
            </nav>
        </div>
    </div>
</div>

{{-- Modal: más info del usuario --}}
<div class="modal fade" id="infoUsuarioModal" tabindex="-1" aria-labelledby="infoUsuarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header text-white" style="background-color: #0A0A2A;">
                <h5 class="modal-title" id="infoUsuarioLabel"><i class="fas fa-info-circle me-2" style="background-color: #0A0A2A;"></i>Más información del usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <p>Aquí se mostrará más información del usuario seleccionado.</p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i>Cerrar
                </button>
            </div>
        </div>
    </div>
</div>
<style>
.pagination .page-item.active .page-link {
    background-color: #0A0A2A !important;
    border-color: #0A0A2A !important;
    color: #fff !important;
}
.pagination .page-link:hover {
    background-color: #0A0A2A !important;
    color: #fff !important;
}

.btn-info-gradient {
    background: linear-gradient(135deg, #73ecf4, #3eb5bd);
    color: black;
    border: none;
    border-radius: 6px;
    padding: 6px 12px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 0.9rem;
    transition: all 0.2s ease;
}

.btn-info-gradient:hover {
    background: linear-gradient(135deg, #61e2ea, #4a9db8);
    transform: translateY(-1px);
}

/* Botón amarillo (Editar) */
.btn-warning-gradient {
    background: linear-gradient(135deg, #facc15, #f59e0b);
    color: black;
    border: none;
    border-radius: 6px;
    padding: 6px 12px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 0.9rem;
    transition: all 0.2s ease;
}

.btn-warning-gradient:hover {
    background: linear-gradient(135deg, #fbbf24, #d97706);
    transform: translateY(-1px);
}

/* Botón rojo (Eliminar) */
.btn-danger-gradient {
    background: linear-gradient(135deg, #ef4444, #b91c1c);
    color: white;
    border: none;
    border-radius: 6px;
    padding: 6px 12px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 0.9rem;
    transition: all 0.2s ease;
}

.btn-danger-gradient:hover {
    background: linear-gradient(135deg, #f87171, #991b1b);
    transform: translateY(-1px);
}
</style>
@endsection
