@extends('layouts.admin.admin_pagPrincipal')

@section('content')
<div class="container-fluid mt-4 text-white">
    {{-- Título principal --}}
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="fw-semibold mb-0">
            <i class="fas fa-project-diagram me-2"></i> Proyecto: {{ $proyecto->SNombreProyecto }}
        </h2>

        {{-- Botón regresar --}}
        <a href="{{ route('admin_proyectos') }}" class="btn btn-secondary btn-sm rounded-3">
            <i class="fas fa-arrow-left me-1"></i> Volver
        </a>
    </div>

    {{-- Descripción --}}
    <div class="card bg-dark text-white rounded-4 shadow-lg mb-4">
        <div class="card-body">
            <p class="mb-2"><strong>Descripción:</strong> {{ $proyecto->SDescripcion }}</p>
            <p><strong>Activo:</strong>
                @if($proyecto->EActivo == 'Si')
                    <span class="badge bg-success">Sí</span>
                @else
                    <span class="badge bg-danger">No</span>
                @endif
                &nbsp;&nbsp;
                <strong>Visible:</strong>
                @if($proyecto->EVisible == 'Si')
                    <span class="badge bg-primary">Sí</span>
                @else
                    <span class="badge bg-secondary">No</span>
                @endif
            </p>

            @if(!empty($proyecto->URL_imagen))
                <img src="{{ $proyecto->URL_imagen }}" alt="Imagen del Proyecto" class="img-fluid rounded-4 mt-3">
            @endif
        </div>
    </div>

    {{-- Título de tabla --}}
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="fw-semibold mb-0 text-white">
            <i class="fas fa-code-branch me-2"></i> Versiones del Proyecto
        </h4>

        <div class="d-flex justify-content-end mb-3">
           <a href="{{ route('adminCargarProyecto', ['id' => $proyecto->IdProyecto]) }}" 
            class="btn btn-success rounded-3 fw-semibold">
            <i class="fas fa-plus">Agregar version</i> 
            </a>

        </div>
        
    </div>

    {{-- Tabla de versiones --}}
    <div class="card border-0 shadow-lg rounded-5" style="background-color: #0A0A2A;">
        <div class="card-body bg-light rounded-bottom-5">
            <table class="table table-hover table-striped align-middle text-center">
         <thead class="mi-encabezado-oscuro">
            <tr class="text-white">
                        <th>ID</th>
                        <th>Nombre Software</th>
                        <th>Versión</th>
                        <th>Fecha</th>
                        <th>Activo</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($versiones as $v)
                        <tr>
                            <td>{{ $v->IdVersionApp }}</td>
                            <td>{{ $v->SNombreSoftware }}</td>
                            <td>{{ $v->SVersion }}</td>
                            <td>{{ $v->DFecha }}</td>
                            <td>
                                @if($v->EActivo == 'Si')
                                    <span class="badge bg-success px-3 py-2">Sí</span>
                                @else
                                    <span class="badge bg-danger px-3 py-2">No</span>
                                @endif
                            </td>
                            <td>
                    <div class="d-flex flex-column align-items-center gap-2">
                        <!-- Ver -->
                        <button class="btn btn-sm btn-info-gradient btnVerVersion" 
                            data-id="{{ $v->IdVersionApp }}"
                            data-nombre="{{ $v->SNombreSoftware }}"
                            data-version="{{ $v->SVersion }}"
                            data-descripcion="{{ $v->SDescripcion }}">
                            <i class="fas fa-eye"></i>
                        </button>

                        <!-- Editar -->
                        <button class="btn btn-sm btn-warning-gradient btnEditarVersion"
                            data-id="{{ $v->IdVersionApp }}"
                            data-nombre="{{ $v->SNombreSoftware }}"
                            data-version="{{ $v->SVersion }}"
                            data-descripcion="{{ $v->SDescripcion }}">
                            <i class="fas fa-edit"></i>
                        </button>

                        <!-- Eliminar -->
                        <button class="btn btn-sm btn-danger-gradient btnEliminarVersion"
                            data-id="{{ $v->IdVersionApp }}">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                    </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No hay versiones registradas para este proyecto</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Ver Detalles -->
<div class="modal fade" id="modalVerVersion" tabindex="-1" aria-labelledby="modalVerVersionLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content text-dark">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title" id="modalVerVersionLabel">Detalles de la Versión</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body" id="modalVerVersionBody">
        {{-- Aquí se cargará dinámicamente la info con JS --}}
      </div>
    </div>
  </div>
</div>

<!-- Modal Eliminar -->
<div class="modal fade" id="modalEliminarVersion" tabindex="-1" aria-labelledby="modalEliminarVersionLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content text-dark">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Eliminar versión</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p>¿Seguro que deseas eliminar esta versión?</p>
      </div>
      <div class="modal-footer">
        <form id="formEliminarVersion" method="POST" action="">
          @csrf
          @method('DELETE')
          <button type="submit" class="btn btn-danger">Sí, eliminar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </form>
      </div>
    </div>
  </div>
</div>




{{-- Estilos gradientes (igual que antes) --}}
@push('styles')
<style>
    .btn-info-gradient {
        background: linear-gradient(135deg, #73ecf4, #3eb5bd);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }
    .btn-warning-gradient {
        background: linear-gradient(135deg, #facc15, #f59e0b);
        color: black;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }
    .btn-danger-gradient {
        background: linear-gradient(135deg, #ef4444, #b91c1c);
        color: white;
        border: none;
        border-radius: 6px;
        padding: 6px 12px;
        transition: all 0.2s ease;
    }
    .btn-info-gradient:hover,
    .btn-warning-gradient:hover,
    .btn-danger-gradient:hover {
        transform: translateY(-1px);
        opacity: 0.9;
    }
    .mi-encabezado-oscuro th {
    background-color: #0A0A2A !important;
    color: #fff !important;
    text-transform: uppercase;
    font-weight: 600;
    border-color: transparent !important;
}
</style>
@endpush
@endsection
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', () => {
    // Ver versión
    document.querySelectorAll('.btnVerVersion').forEach(btn => {
        btn.addEventListener('click', e => {
            const id = btn.dataset.id;
            const nombre = btn.dataset.nombre;
            const version = btn.dataset.version;
            const descripcion = btn.dataset.descripcion;

            const contenido = `
                <p><strong>ID:</strong> ${id}</p>
                <p><strong>Nombre:</strong> ${nombre}</p>
                <p><strong>Versión:</strong> ${version}</p>
                <p><strong>Descripción:</strong> ${descripcion}</p>
            `;
            document.getElementById('modalVerVersionBody').innerHTML = contenido;
            new bootstrap.Modal(document.getElementById('modalVerVersion')).show();
        });
    });

    // Editar versión
    document.querySelectorAll('.btnEditarVersion').forEach(btn => {
        btn.addEventListener('click', e => {
            const id = btn.dataset.id;
            const nombre = btn.dataset.nombre;
            const version = btn.dataset.version;
            const descripcion = btn.dataset.descripcion;

            document.getElementById('IdVersionApp').value = id;
            document.getElementById('SNombreSoftware').value = nombre;
            document.getElementById('SVersion').value = version;
            document.getElementById('SDescripcion').value = descripcion;

            document.getElementById('modalFormVersionLabel').textContent = 'Editar versión';
            new bootstrap.Modal(document.getElementById('modalFormVersion')).show();
        });
    });

    // Eliminar versión
    document.querySelectorAll('.btnEliminarVersion').forEach(btn => {
        btn.addEventListener('click', e => {
            const id = btn.dataset.id;
            const form = document.getElementById('formEliminarVersion');
            form.action = `/admin/versiones/${id}`; // ajusta según tus rutas
            new bootstrap.Modal(document.getElementById('modalEliminarVersion')).show();
        });
    });
});
</script>
@endpush
