
@extends('layouts.admin.admin_pagPrincipal')

@section('content')
    <div class="container py-4">
    <div class="profile-container bg-white rounded-4 shadow-lg p-4 mx-auto" style="max-width: 500px;">
        <div class="profile-header text-center mb-4 border-bottom pb-3">
                  <div class="user-avatar mb-3 mx-auto d-flex align-items-center justify-content-center rounded-circle bg-primary text-white"
                style="width: 80px; height: 80px;">
                <i class="fas fa-user fa-2x"></i>
            </div>
                <h2 class="fw-semibold text-dark">Mi Perfil</h2>
                <p class="text-muted mb-0">Actualiza tu información personal</p>
        </div>
            <!-- Mostrar errores -->
            @if($errors->any())
                <div class="alert alert-danger error-alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(session('status'))
                <div class="alert alert-success error-alert">
                    {{ session('status') }}
                </div>
            @endif

            <form method="POST" action="{{ route('perfil.update') }}">
                @csrf
                @method('PUT')

                <div class="profile-field">
                    <label for="SNombre" class="form-label">
                        <i class="fas fa-user me-2"></i>Nombre Completo
                    </label>
                    <input type="text" 
                           class="form-control @error('SNombre') is-invalid @enderror" 
                           id="SNombre" 
                           name="SNombre" 
                           value="{{ old('SNombre', $user->SNombre) }}" 
                           required
                           placeholder="Ingresa tu nombre completo">
                    @error('SNombre')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="SMail" class="form-label">
                        <i class="fas fa-envelope me-2"></i>Correo Electrónico
                    </label>
                    <input type="email" 
                           class="form-control @error('SMail') is-invalid @enderror" 
                           id="SMail" 
                           name="SMail" 
                           value="{{ old('SMail', $user->SMail) }}" 
                           required
                           placeholder="Ingresa tu correo electrónico">
                    @error('SMail')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label for="STelefono" class="form-label">
                        <i class="fas fa-phone me-2"></i>Teléfono
                    </label>
                    <input type="tel" 
                           class="form-control @error('STelefono') is-invalid @enderror" 
                           id="STelefono" 
                           name="STelefono" 
                           value="{{ old('STelefono', $user->STelefono) }}"
                           placeholder="Ingresa tu número de teléfono">
                    @error('STelefono')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="profile-field">
                    <label class="form-label">
                        <i class="fas fa-lock me-2"></i>Contraseña
                    </label>
                    <div>
                      <button type="button" class="btn btn-outline-primary" id="changePasswordBtn">
                        <i class="fas fa-key me-2"></i>Cambiar Contraseña
                    </button>

                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a   href="{{ route('admin_dashboard') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Volver
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Guardar Cambios
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal para cambiar contraseña -->
<div class="modal fade" id="passwordModal" tabindex="-1" aria-labelledby="passwordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordModalLabel">
                    <i class="fas fa-key me-2"></i>Cambiar Contraseña
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <div class="modal-body">
                <form id="passwordForm">
                    @csrf
                    <div class="mb-3">
                        <label for="newPassword" class="form-label">Nueva Contraseña</label>
                        <input type="password" class="form-control" id="newPassword" name="newPassword"
                            required minlength="8" placeholder="Ingresa la nueva contraseña">
                    </div>
                    <div class="mb-3">
                        <label for="confirmPassword" class="form-label">Confirmar Contraseña</label>
                        <input type="password" class="form-control" id="confirmPassword"
                            name="newPassword_confirmation" required placeholder="Confirma la nueva contraseña">
                        <div class="password-match-error text-danger small mt-1" id="passwordMatchError" style="display:none;">
                            <i class="fas fa-exclamation-triangle me-1"></i>Las contraseñas no coinciden
                        </div>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>Cancelar
                </button>
                <button type="button" class="btn btn-primary" id="savePassword">
                    <i class="fas fa-save me-2"></i>Guardar
                </button>
            </div>
        </div>
    </div>
</div>



    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
{{-- Scripts personalizados --}}
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const changePasswordBtn = document.getElementById('changePasswordBtn');
    const modalElement = document.getElementById('passwordModal');
    const savePassword = document.getElementById('savePassword');
    const newPassword = document.getElementById('newPassword');
    const confirmPassword = document.getElementById('confirmPassword');
    const passwordMatchError = document.getElementById('passwordMatchError');

    // Inicializar el modal de Bootstrap
    let passwordModal = null;
    if (bootstrap && modalElement) {
        passwordModal = new bootstrap.Modal(modalElement);
    } else {
        console.error('Bootstrap Modal no está disponible o el elemento no existe.');
        return;
    }

    // Abrir modal al hacer clic
    changePasswordBtn.addEventListener('click', () => passwordModal.show());

    // Validar contraseñas
    function validatePasswords() {
        if (newPassword.value !== confirmPassword.value) {
            passwordMatchError.style.display = 'block';
            confirmPassword.classList.add('is-invalid');
            return false;
        }
        passwordMatchError.style.display = 'none';
        confirmPassword.classList.remove('is-invalid');
        return true;
    }

    newPassword.addEventListener('input', validatePasswords);
    confirmPassword.addEventListener('input', validatePasswords);

    savePassword.addEventListener('click', function() {
        if (!validatePasswords() || newPassword.value.length < 8) return;

        const formData = new FormData(document.getElementById('passwordForm'));
        savePassword.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Guardando...';
        savePassword.disabled = true;

        fetch('{{ route("perfil.password") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(res => res.json())
        .then(data => {
            alert(data.message || 'Contraseña actualizada');
            passwordModal.hide();
        })
        .catch(() => alert('Error al cambiar la contraseña'))
        .finally(() => {
            savePassword.innerHTML = '<i class="fas fa-save me-2"></i>Guardar';
            savePassword.disabled = false;
        });
    });
});
</script>
@endpush

@endsection