@extends('layouts.guest.guest')

@section('content')
    <div class="page-fade">

        <div class="container my-4">

            {{-- =========================================================
                (tarjeta dividida: texto + imagen horizontal)
            ========================================================== --}}
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm overflow-hidden rounded-3">
                            <div class="row g-0 align-items-stretch">
                                {{-- texto --}}
                                <div class="col-12 col-lg-6 p-4 p-lg-5 d-flex">
                                    <div class="my-auto">

                                        {{-- Titulo --}}
                                        <h5 class="text-uppercase small fw-semibold text-muted mb-2">Alcances de Activismo</h5>
                                        {{-- Subtitulo --}}
                                        <h3 class="fw-bold mb-3">NOIL Activismo</h3>
                                        {{-- Texto --}}
                                        <p class="mb-0">
                                            Activismo es una aplicación personalizada para la gestión de información de grupos activistas que centraliza y optimiza la captura, control y análisis de información.
Permite administrar datos personales, ubicaciones, secciones y estructuras jerárquicas (líder, coordinador, activista, promovido) con validación biométrica.
                                        </p>
                                    </div>
                                </div>
                                {{-- imagen (sin estirar, conserva resolución) --}}
                                <div class="col-12 col-lg-6">
                                    <div class="media-box h-100" style="background: white;">
                                        <img src="{{ asset('img/acerca/acerca-14.jpg') }}" class="media-contain"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            {{-- =========================================================
                 2) (EN TARJETA)
            ========================================================== --}}
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 app-section-card">
                            <div class="card-body p-4 p-lg-5">

                                {{-- título --}}
                                <div class="row justify-content-center text-center mb-3">
                                    <div class="col-12">

                                        {{-- titulo --}}
                                        <h5 class="text-uppercase small fw-semibold text-muted mb-1">MÓDULO DE ACTIVISMO</h5>
                                        {{-- subtitulo --}}
                                        <h3 class="fw-bold mb-0">Áreas de aplicación</h3>
                                        {{-- texto --}}
                                        <p class="mb-0"></p>
                                    </div>
                                </div>

                                {{-- grid de áreas (4) --}}
                                <div class="row g-4 justify-content-center">
                                    {{-- desarrollo inmobiliario --}}
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media" style="background: white;">
                                                <img src="{{ asset('img/acerca/acerca-07.jpg') }}" class="app-card__img"
                                                    alt="">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Gestión territorial</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Control y segmentación por entidad, municipio, sección y manzana, con indicadores de cobertura y desempeño.</p>
                                            </div>
                                        </article>
                                    </div>

                                    {{-- infraestructura --}}
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media" style="background: white;">
                                                <img src="{{ asset('img/acerca/acerca-13.jpg') }}" class="app-card__img"
                                                    alt="">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Estructura organizativa</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Administración jerárquica de roles (líderes, coordinadores, activistas, promovidos) y sus relaciones de supervisión.</p>
                                            </div>
                                        </article>
                                    </div>

                                    {{-- industrial --}}
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media" style="background: white;">
                                                <img src="{{ asset('img/acerca/acerca-11.jpg') }}" class="app-card__img"
                                                    alt="">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Control de apoyos</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Registro y seguimiento de apoyos entregados, vigencias, movimientos y resultados en campo.</p>
                                            </div>
                                        </article>
                                    </div>

                                    {{-- urbanización --}}
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media" style="background: white;">
                                                <img src="{{ asset('img/acerca/acerca-09.jpg') }}" class="app-card__img"
                                                    alt="">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Análisis estadístico y reportes</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Generación de reportes PDF y Excel sobre participación, cobertura y métricas de género o actividad.</p>
                                            </div>
                                        </article>
                                    </div>
                                </div>{{-- /row --}}

                            </div>{{-- /card-body --}}
                        </div>{{-- /card --}}
                    </div>
                </div>
            </section>

            {{-- =========================================================
                 3) (solo texto + checklist)
            ========================================================== --}}
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 overflow-hidden">
                            <div class="row g-0">
                                {{-- texto + checklist --}}
                                <div class="col-12 p-4 p-lg-5">
                                    {{-- titulo --}}
                                    <h5 class="text-uppercase small fw-semibold text-muted mb-1">Características</h5>
                                    {{-- subtitulo --}}
                                    <p class="mb-4">Activismo centraliza la información en un entorno seguro, evita duplicidad de registros y permite búsquedas rápidas y confiables, garantizando la integridad de la base de datos y el seguimiento en tiempo real de los resultados.</p>

                                    {{-- lista de elementos --}}
                                    <ul class="list-unstyled m-0 feature-list" id="featureList" aria-live="polite">
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            {{-- check --}}
                                            <span class="feature-check" aria-hidden="true"></span>
                                            {{-- texto --}}
                                            <span>Identificación única por datos biométricos o credencial INE</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>Control de acceso por usuario y nivel jerárquico</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>Reportes personalizados en PDF y Excel</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            {{-- =========================================================
                 4) (pestañas + imagen vertical)
            ========================================================== --}}
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 overflow-hidden">

                            {{-- título dentro de la tarjeta --}}
                            <div class="card-header bg-white text-center py-4">
                                <h3 class="fw-bold mb-0">Segmentos del Software</h3>
                            </div>

                            <div class="row g-0 align-items-stretch">
                                {{-- imagen vertical (izquierda en >= lg) --}}
                                <div class="col-12 col-lg-5 order-lg-1">
                                    <div class="media-box h-100 media-box--tall bg-white p-3">
                                        <img src="{{ asset('img/acerca/acerca-16.jpg') }}" class="media-contain"
                                            alt="">
                                    </div>
                                </div>

                                {{-- pestañas/colapsables (derecha en >= lg) --}}
                                <div class="col-12 col-lg-7 p-3 p-lg-4 order-lg-2">
                                    <div class="list-group list-group-flush shadow-sm rounded-3 overflow-hidden"
                                        role="tablist">

                                        {{-- item --}}
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Registro y control de activistas</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">Administración de datos personales, ubicaciones y niveles jerárquicos.</p>
                                        </div>

                                        {{-- item --}}
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Cartografía y secciones</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">Visualización geográfica por municipio, sección o manzana.</p>
                                        </div>

                                        {{-- item --}}
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Reportes y métricas</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">Indicadores de desempeño y participación.</p>
                                        </div>

                                        {{-- item --}}
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Configuración biométrica</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">Gestión de dispositivos y validaciones de identidad.</p>
                                        </div>

                                        {{-- item --}}
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Apoyos y movimientos</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">Seguimiento y control de entregas, vigencias y resultados.</p>
                                        </div>


                                    </div>
                                </div>
                            </div>{{-- /row --}}
                        </div>
                    </div>
                </div>
            </section>

    </div>{{-- /.page-fade --}}

    {{-- ===================== estilos ===================== --}}
    <style>
        :root {
            --dark-1: #0A0A2A;
            --dark-2: #13063E;
            --accent-1: #4a3b9e;
            --cyan-1: #33E1F7;
            --cyan-2: #00C2E8;
            --cyan-3: #0AA1C4;
            --ink-1: #001725;
        }

        /* fondo base + animación */
        body,
        .page-fade {
            background-color: var(--dark-2);
            color: #f8f9fa;
            animation: fadeInPage .6s ease forwards;
            opacity: 0;
        }

        @keyframes fadeInPage {
            to {
                opacity: 1
            }
        }

        /* tarjetas claras para contraste con fondo oscuro */
        .card {
            background: #fff;
            color: #212529
        }

        /* contenedor sección en tarjeta */
        .app-section-card {
            background: #ffffff;
            box-shadow: 0 20px 50px rgba(19, 6, 62, .08), 0 6px 18px rgba(19, 6, 62, .05);
            border-radius: 1rem;
        }

        /* media boxes: contener imagen (no deformar) */
        .media-box {
            position: relative;
            width: 100%;
            height: 100%;
            min-height: 260px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #0b0b0b;
        }

        .media-box--tall {
            min-height: 360px
        }

        .media-contain {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
            width: 100%;
            height: auto;
            display: block;
        }

        /* áreas de aplicación */
        .app-card {
            min-height: 230px;
            background: #000
        }

        .app-card__media {
            position: absolute;
            inset: 0;
            display: flex
        }

        .app-card__img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            opacity: .85
        }

        .app-card__overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(180deg, rgba(0, 0, 0, .35) 0%, rgba(0, 0, 0, .7) 100%);
            transition: opacity .25s ease;
        }

        .app-card__title {
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            padding: 1rem;
            z-index: 2
        }

        .text-shadow {
            text-shadow: 0 2px 10px rgba(0, 0, 0, .55)
        }

        .app-card__content {
            position: absolute;
            inset: 0;
            color: #fff;
            z-index: 2;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            opacity: 0;
            transform: translateY(6px);
            transition: opacity .25s ease, transform .25s ease;
            background: rgba(0, 0, 0, .38);
        }

        .app-card:hover .app-card__overlay {
            opacity: .25
        }

        .app-card:hover .app-card__content {
            opacity: 1;
            transform: translateY(0)
        }

        /* características – checklist (más lento) */
        .feature-check {
            width: 22px;
            height: 22px;
            border-radius: 6px;
            background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            box-shadow: 0 6px 18px rgba(0, 194, 232, .35);
            position: relative;
            flex: 0 0 22px;
            transform: scale(.85);
            opacity: .25;
            transition: transform .45s ease, opacity .45s ease;
        }

        .feature-check::after {
            content: "";
            position: absolute;
            inset: 0;
            background: #001725;
            opacity: 0;
            transition: opacity .45s ease;
            mask: url("data:image/svg+xml,%3Csvg viewBox='0 0 16 16' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill='white' d='M6.173 14.727a1 1 0 0 1-.768-.36l-3.8-4.5a1 1 0 1 1 1.538-1.275l3.02 3.578L12.8 2.467a1 1 0 1 1 1.666 1.11L7.08 14.184a1 1 0 0 1-.754.48 1 1 0 0 1-.153.01z'/%3E%3C/svg%3E") center/14px 14px no-repeat;
            -webkit-mask: url("data:image/svg+xml,%3Csvg viewBox='0 0 16 16' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill='white' d='M6.173 14.727a1 1 0 0 1-.768-.36l-3.8-4.5a1 1 0 1 1 1.538-1.275l3.02 3.578L12.8 2.467a1 1 0 1 1 1.666 1.11L7.08 14.184a1 1 0 0 1-.754.48 1 1 0 0 1-.153.01z'/%3E%3C/svg%3E") center/14px 14px no-repeat;
        }

        .feature-checked .feature-check {
            opacity: 1;
            transform: scale(1)
        }

        .feature-checked .feature-check::after {
            opacity: 1
        }

        /* —— sección 4 (segmentos) —— */
        .list-group-item {
            background: #fff;
            color: #212529;
            font-size: 1.1rem;
        }

        .seg-btn {
            background: #fff;
            padding: 1.25rem 1.5rem;
        }

        .seg-btn span {
            font-size: 1.2rem;
            line-height: 1.5;
        }

        .seg-btn .fa-chevron-down {
            transition: transform .25s ease;
            font-size: 1rem;
        }

        .seg-btn .fa-chevron-down.rotate {
            transform: rotate(180deg)
        }

        .seg-content {
            max-height: 0;
            overflow: hidden;
            padding: 0 1.25rem;
            background: #fdfdfd;
            border-top: 1px solid #e5e5e5;
            transition: max-height .35s ease, padding .35s ease;
        }

        .seg-content p {
            color: #212529;
            font-size: 1.1rem;
            line-height: 1.7;
        }

        .seg-content.open {
            padding: 1.1rem 1.25rem;
            max-height: 400px;
        }

        /* ajustar tamaño de la imagen de la sección app móvil */
        .media-box.app-mobile img {
            max-width: 75%;
            /* reduce al 75% del ancho disponible */
            height: auto;
            margin: 0 auto;
            /* centra horizontalmente */
            display: block;
        }


        /* responsivo */
        @media (max-width:991.98px) {
            .media-box {
                min-height: 220px
            }

            .media-box--tall {
                min-height: 300px
            }
        }

        @media (min-width:992px) {
            .media-box--tall {
                min-height: 380px
            }
        }
    </style>

    {{-- ===================== scripts ===================== --}}
    <script>
        // checklist: animación escalonada al entrar en viewport (más lenta)
        (() => {
            const list = document.getElementById('featureList');
            if (!list) return;
            const items = Array.from(list.children);

            const io = new IntersectionObserver(entries => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        items.forEach((li, idx) => {
                            setTimeout(() => li.classList.add('feature-checked'), 220 * idx);
                        });
                        io.disconnect();
                    }
                });
            }, {
                threshold: .25
            });

            io.observe(list);
        })();

        // segmentos: toggle suave + animación
        (() => {
            const btns = document.querySelectorAll('.seg-btn');

            btns.forEach(btn => {
                btn.addEventListener('click', () => {
                    const content = btn.nextElementSibling;
                    if (!content || !content.classList) return;

                    const chevron = btn.querySelector('.fa-chevron-down');
                    const willOpen = !content.classList.contains('open');

                    // cerrar otros abiertos
                    document.querySelectorAll('.seg-content.open').forEach(c => c.classList.remove(
                        'open'));
                    document.querySelectorAll('.seg-btn .fa-chevron-down.rotate').forEach(i => i
                        .classList.remove('rotate'));

                    if (willOpen) {
                        content.classList.add('open');
                        chevron?.classList.add('rotate');
                    } else {
                        content.classList.remove('open');
                        chevron?.classList.remove('rotate');
                    }
                });
            });
        })();
    </script>
@endsection
