{{-- resources/views/web/CO/descargasCO.blade.php --}}
@extends('layouts.guest.guest')

@section('content')

{{-- ====================== ESTILOS DEL COMPONENTE ====================== --}}
<link rel="stylesheet" href="{{ asset('css/components/software-card.css') }}">

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-12">
            {{-- Header de la página --}}
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-white mb-3">
                    <i class="fas fa-download me-3"></i>Descargas de Compras y Requisiciones
                </h1>
                <p class="lead text-white-50">
                    Descarga la última versión del software para tu sistema operativo
                </p>
            </div>

            {{-- Verificar si hay plataformas disponibles --}}
            @if(empty($platforms))
                {{-- NO HAY PLATAFORMAS: Mostrar card vacía sin logo --}}
                @include('components.empty-platforms-card')
            @else
                {{-- SÍ HAY PLATAFORMAS: Mostrar layout normal --}}
                <div class="download-layout">
                    <div class="download-layout__sidebar">
                        {{-- Logo --}}
                        <div class="download-layout__logo">
                            <img src="{{ asset('img/software_noil_blanco.png') }}" alt="NOIL Software" class="img-fluid">
                        </div>

                        <div class="download-layout__os-buttons">
                            @foreach($platforms as $index => $platform)
                                <button class="os-btn {{ $index === 0 ? 'os-btn--active' : '' }}"
                                        data-platform="{{ $platform['codigo'] }}">
                                    <i class="{{ $platform['config']['platformIcon'] }}"></i>
                                    <span>{{ $platform['config']['platformName'] }}</span>
                                </button>
                            @endforeach
                        </div>
                    </div>

                    <div class="download-layout__main">
                        @foreach($platforms as $index => $platform)
                            <div class="platform-card {{ $index === 0 ? 'platform-card--active' : '' }}"
                                 data-platform-card="{{ $platform['codigo'] }}">
                                @if(isset($platform['versions']) && $platform['versions']->isNotEmpty())
                                    @include('components.software-card', [
                                        'platformName'     => $platform['config']['platformName'],
                                        'platformIcon'     => $platform['config']['platformIcon'],
                                        'platformClass'    => $platform['config']['platformClass'],
                                        'softwareName'     => 'Control de Obra',
                                        'versions'         => $platform['versions'],
                                        'filesPerVersion'  => $archivosPorVersion,
                                        'colorPrimary'     => $platform['config']['colorPrimary'],
                                        'colorStrong'      => $platform['config']['colorStrong'],
                                        'colorWeak'        => $platform['config']['colorWeak'],
                                        'colorOnBrand'     => $platform['config']['colorOnBrand'],
                                        'gradient'         => $platform['config']['gradient'],
                                        'documentationUrl' => $docUrlProyecto ?? null,
                                        'videoUrl'         => $videoUrlProyecto ?? null,
                                        'uniqueId'         => 'co-' . $platform['codigo']
                                    ])
                                @else
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-body text-center py-5">
                                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">No hay versiones disponibles para {{ $platform['config']['platformName'] }}</h5>
                                            <p class="text-muted mb-0">Por favor, vuelve más tarde para ver las actualizaciones disponibles.</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

        </div>
    </div>
</div>

{{-- ====================== ESTILOS ADICIONALES ====================== --}}
<style>
    /* Animación de entrada */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .container > .row > .col-12 > * {
        animation: fadeInUp 0.6s ease-out both;
    }

    .container > .row > .col-12 > *:nth-child(2) {
        animation-delay: 0.1s;
    }

    .container > .row > .col-12 > *:nth-child(3) {
        animation-delay: 0.2s;
    }

    .container > .row > .col-12 > *:nth-child(4) {
        animation-delay: 0.3s;
    }

    /* Mejoras visuales */
    .lead {
        font-size: 1.125rem;
    }

    .display-5 {
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
    }

    /* Cards de información */
    .card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15) !important;
    }

    /* Iconos de características */
    .fa-shield-alt,
    .fa-sync-alt,
    .fa-life-ring {
        transition: transform 0.3s ease;
    }

    .card-body:hover .fa-shield-alt,
    .card-body:hover .fa-sync-alt,
    .card-body:hover .fa-life-ring {
        transform: scale(1.1);
    }

    /* Alert mejorado */
    .alert-info {
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        color: #0d47a1;
    }

    .alert-info .alert-heading {
        color: #01579b;
    }

    .alert-info ul {
        list-style-type: none;
    }

    .alert-info ul li::before {
        content: "✓ ";
        color: #0277bd;
        font-weight: bold;
        margin-right: 0.5rem;
    }

    /* Responsive adjustments */
    @media (max-width: 767.98px) {
        .display-5 {
            font-size: 2rem;
        }

        .lead {
            font-size: 1rem;
        }

        h4.fw-bold {
            font-size: 1.25rem;
        }
    }

    /* ====================== LAYOUT DE DOS COLUMNAS ====================== */

    .download-layout {
        display: grid;
        grid-template-columns: 250px 1fr;
        gap: 2rem;
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 1rem;
    }

    /* SIDEBAR (Columna Izquierda) */
    .download-layout__sidebar {
        display: flex;
        flex-direction: column;
        gap: 2rem;
    }

    .download-layout__logo {
        background: rgba(255, 255, 255, 0.05);
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }

    .download-layout__logo img {
        max-width: 100%;
        height: auto;
        filter: brightness(1.1);
    }

    .download-layout__os-buttons {
        display: flex;
        flex-direction: column;
        gap: 0.75rem;
    }

    /* BOTONES DE SO */
    .os-btn {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1rem 1.25rem;
        background: rgba(255, 255, 255, 0.05);
        border: 2px solid rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        color: rgba(255, 255, 255, 0.7);
        font-size: 1rem;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .os-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
        transition: left 0.5s ease;
    }

    .os-btn:hover::before {
        left: 100%;
    }

    .os-btn:hover {
        background: rgba(255, 255, 255, 0.08);
        border-color: rgba(255, 255, 255, 0.2);
        color: rgba(255, 255, 255, 0.9);
        transform: translateX(4px);
    }

    .os-btn i {
        font-size: 1.5rem;
        transition: transform 0.3s ease;
    }

    .os-btn:hover i {
        transform: scale(1.1);
    }

    .os-btn span {
        flex: 1;
        text-align: left;
    }

    /* Botón activo */
    .os-btn--active {
        background: linear-gradient(135deg, #0AA1C4 0%, #064E60 100%);
        border-color: #0AA1C4;
        color: #fff;
        box-shadow: 0 4px 15px rgba(10, 161, 196, 0.3);
    }

    .os-btn--active:hover {
        transform: translateX(4px);
        box-shadow: 0 6px 20px rgba(10, 161, 196, 0.4);
    }

    /* PANEL PRINCIPAL (Columna Derecha) */
    .download-layout__main {
        position: relative;
        min-height: 500px;
    }

    .platform-card {
        display: none;
        opacity: 0;
        animation: fadeOut 0.3s ease-out forwards;
    }

    .platform-card--active {
        display: block;
        animation: fadeInCard 0.4s ease-out forwards;
    }

    @keyframes fadeInCard {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translateY(0);
        }
        to {
            opacity: 0;
            transform: translateY(20px);
        }
    }

    /* ====================== RESPONSIVE ====================== */

    @media (max-width: 991.98px) {
        .download-layout {
            grid-template-columns: 200px 1fr;
            gap: 1.5rem;
        }

        .os-btn {
            padding: 0.875rem 1rem;
        }

        .os-btn i {
            font-size: 1.25rem;
        }

        .os-btn span {
            font-size: 0.9rem;
        }
    }

    @media (max-width: 767.98px) {
        .download-layout {
            grid-template-columns: 1fr;
            gap: 2rem;
        }

        .download-layout__sidebar {
            order: 1;
        }

        .download-layout__main {
            order: 2;
        }

        .download-layout__os-buttons {
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: center;
        }

        .os-btn {
            flex: 1;
            min-width: 140px;
            justify-content: center;
        }

        .os-btn:hover {
            transform: translateY(-2px);
        }

        .os-btn--active:hover {
            transform: translateY(-2px);
        }

        .download-layout__logo {
            max-width: 200px;
            margin: 0 auto;
        }
    }

    @media (max-width: 575.98px) {
        .os-btn span {
            font-size: 0.85rem;
        }

        .os-btn i {
            font-size: 1.15rem;
        }

        .os-btn {
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            min-width: 120px;
        }
    }
</style>

{{-- ====================== SCRIPTS ADICIONALES ====================== --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {

        // ========== SISTEMA DE TABS PARA PLATAFORMAS ==========
        const platformButtons = document.querySelectorAll('.os-btn');
        const platformCards = document.querySelectorAll('.platform-card');

        platformButtons.forEach(button => {
            button.addEventListener('click', function() {
                const selectedPlatform = this.getAttribute('data-platform');

                // Actualizar estado de botones
                platformButtons.forEach(btn => btn.classList.remove('os-btn--active'));
                this.classList.add('os-btn--active');

                // Mostrar/ocultar cards con animación
                platformCards.forEach(card => {
                    const cardPlatform = card.getAttribute('data-platform-card');

                    if (cardPlatform === selectedPlatform) {
                        card.classList.add('platform-card--active');
                    } else {
                        card.classList.remove('platform-card--active');
                    }
                });
            });
        });

        // Smooth scroll para enlaces de video
        document.querySelectorAll('a[href^="#video-"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            });
        });
    });
</script>

@endsection
