@extends('layouts.guest.guest')

@section('content')
    <div class="page-fade">

        <div class="container my-4">

            {{-- ===================== franja superior ===================== --}}
            <div class="row justify-content-center text-center">
                <div class="col-12 col-md-8 col-lg-6">
                    <div class="support-strip text-light py-4 rounded-top text-black">
                        <h4 class="fw-bold mb-1">Soporte</h4>
                        <p class="mb-0">¿Necesitas ayuda? Escríbenos por WhatsApp.</p>
                    </div>
                </div>
            </div>

            {{-- ===================== sección principal ===================== --}}
            <div class="row justify-content-center">
                <div class="col-12 col-md-8 col-lg-6 d-flex">
                    <div class="support-card card border-0 shadow-sm w-100 rounded-bottom">
                        <div class="card-body d-flex gap-3 align-items-start">
                            <div class="icon-badge" aria-hidden="true">
                                <i class="fa-brands fa-whatsapp"></i>
                            </div>

                            <div class="flex-grow-1">
                                <h6 class="mb-2 text-uppercase small fw-semibold text-muted">soporte por whatsapp</h6>
                                <p class="mb-2">Atención directa para resolver dudas técnicas, incidencias y orientación
                                    de uso.</p>
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <a href="https://wa.me/529331344382" class="btn btn-whatsapp px-3" target="_blank"
                                        rel="noopener noreferrer">
                                        <i class="fa-brands fa-whatsapp me-2"></i> Chatear con soporte
                                    </a>
                                    <span class="small text-muted">Horario sugerido: lun–sáb, 8:00–17:00</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>{{-- /.container --}}

    </div>{{-- /.page-fade --}}

    <style>
        /* paleta */
        :root {
            --dark-1: #0A0A2A;
            --dark-2: #13063E;
            --accent-1: #4a3b9e;
            --cyan-1: #73ecf4;
            --cyan-2: #61e2ea;
            --cyan-3: #3eb5bd;
            --ink-1: #001725;
        }

        .page-fade {
            animation: fadeInPage .6s ease forwards;
            opacity: 0;
        }

        @keyframes fadeInPage {
            to {
                opacity: 1;
            }
        }

        .support-strip {
            background: linear-gradient(135deg, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            border-bottom: 1px solid rgba(255, 255, 255, .08);
            /* no rounded aquí, solo top */
        }

        .support-card {
            border-radius: 0 0 .5rem .5rem;
            /* solo bottom redondeado */
            transition: transform .2s ease, box-shadow .2s ease;
        }

        .support-card:hover {
            box-shadow: 0 10px 24px rgba(0, 0, 0, .12);
        }

        .icon-badge {
            flex: 0 0 44px;
            height: 44px;
            width: 44px;
            display: grid;
            place-items: center;
            border-radius: 12px;
            background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            color: var(--ink-1);
            box-shadow: 0 6px 18px rgba(0, 194, 232, .35);
        }

        /* botón estilo WhatsApp (solo colores) */
        .btn-whatsapp {
            background-color: #25D366;
            /* verde WhatsApp */
            border-color: #25D366;
            color: #fff;
        }

        .btn-whatsapp:hover {
            background-color: #1ebe57;
            /* hover más oscuro */
            border-color: #1ebe57;
            color: #fff;
        }

        .btn-whatsapp:focus {
            box-shadow: 0 0 0 .25rem rgba(37, 211, 102, .25);
        }

        .btn-whatsapp:active {
            background-color: #128C7E;
            /* activo / pressed */
            border-color: #128C7E;
            color: #fff;
        }

        .btn-whatsapp i {
            color: #fff;
        }

        .btn-whatsapp:disabled,
        .btn-whatsapp.disabled {
            background-color: #c8efd7;
            border-color: #c8efd7;
            color: #2e7d32;
        }
    </style>
@endsection
