{{-- resources/views/web/portada.blade.php --}}
@extends('layouts.guest.guest')

@section('content')
<div class="page-fade">
  <div class="d-flex justify-content-center">
    <div class="position-relative w-75">
      <div id="carouselExample" class="carousel slide" data-bs-ride="carousel">
        {{-- Indicadores --}}
        <div class="carousel-indicators">
          <button type="button" data-bs-target="#carouselExample" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
          <button type="button" data-bs-target="#carouselExample" data-bs-slide-to="1" aria-label="Slide 2"></button>
        </div>

        <div class="carousel-inner rounded-3" style="background-color:#13063E">
          {{-- SLIDE 1 (activo) --}}
          <div class="carousel-item active">
            <div class="ratio aspect-dynamic">
              <picture class="d-block w-100 h-100">
                {{-- En portrait usa la vertical --}}
                <source media="(orientation: portrait)" srcset="{{ asset('img/co_vertical.jpg') }}">
                {{-- Fallback / landscape: horizontal --}}
                <img
                  src="{{ asset('img/co_horizontal.jpg') }}"
                  alt="Portada Wynni / Control de Obra"
                  class="slide-img"
                  loading="lazy">
              </picture>
            </div>
            {{-- (Opcional) leyenda
            <div class="carousel-caption d-none d-md-block">
              <h5>Control de Obra</h5>
              <p>Suite de herramientas para tu proyecto.</p>
            </div> --}}
          </div>

          {{-- SLIDE 2 --}}
          <div class="carousel-item">
            <div class="ratio aspect-dynamic">
              <picture class="d-block w-100 h-100">
                <source media="(orientation: portrait)" srcset="{{ asset('img/activismo_vertical.jpg') }}">
                <img
                  src="{{ asset('img/activismo_horizontal.jpg') }}"
                  alt="Portada 2 / Activismo"
                  class="slide-img"
                  loading="lazy">
              </picture>
            </div>
          </div>
        </div>

        {{-- Controles --}}
        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample" data-bs-slide="prev">
          <span class="carousel-control-prev-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Anterior</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#carouselExample" data-bs-slide="next">
          <span class="carousel-control-next-icon" aria-hidden="true"></span>
          <span class="visually-hidden">Siguiente</span>
        </button>
      </div>
    </div>
  </div>
</div>

<style>
  /* Animación de entrada */
  .page-fade { animation: fadeInPage 1.2s ease forwards; opacity: 0; }
  @keyframes fadeInPage { to { opacity: 1; } }

  /* Contenedor ratio: 16:9 por defecto */
  .ratio.aspect-dynamic { --bs-aspect-ratio: 56.25%; }

  /* En portrait: 9:16 */
  @media (orientation: portrait) {
    .ratio.aspect-dynamic { --bs-aspect-ratio: 177.78%; }
  }

  /* Asegurar que picture e img llenen el marco ratio */
  .ratio > picture,
  .ratio > picture > img { width: 100%; height: 100%; }

  /* Landscape: llenar sin barras */
  .slide-img {
    width: 100%;
    height: 100%;
    object-fit: cover;       /* llena el marco 16:9 */
    object-position: center; /* foco centrado */
    background: #13063E;     /* color de barras si aplica */
    display: block;
  }

  /* Portrait: mostrar completa la vertical (con barras laterales de marca) */
  @media (orientation: portrait) {
    .slide-img {
      object-fit: contain;
      background: #13063E;
    }
  }
</style>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const el = document.getElementById('carouselExample');
  if (!el) return;

  // Inicialización del carrusel
  const carousel = new bootstrap.Carousel(el, {
    interval: 4000,    // 4 segundos
    pause: 'hover',    // pausar al poner el mouse encima
    ride: 'carousel',  // inicia automáticamente
    touch: true,       // habilita swipe en móviles
    keyboard: true     // navegación con teclado
  });

  // (Opcional) Forzar redimensionado del ratio al rotar el dispositivo
  window.addEventListener('orientationchange', () => {
    // Reflujo para recalcular layout tras el cambio de orientación
    document.body.offsetHeight; // no-op para forzar repaint
  });
});
</script>
@endsection
