<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebController;
use App\Http\Controllers\admin\AdminWebController;
use App\Http\Controllers\admin\CargarProyectoController;
use App\Http\Controllers\admin\EditarPerfilController;
use App\Http\Controllers\admin\PerfilController;
use App\Http\Controllers\clientes\ClienteVistaProyectoController;

// === RUTAS PÚBLICAS ===
Route::controller(WebController::class)->group(function () {
    // Route::get('/', 'inicio')->name('web.inicio');
    // Route::get('/descargas', 'descargas')->name('web.descargas');

    Route::get('/contacto', 'contacto')->name('web.contacto');
    Route::get('/privacidad', 'privacidad')->name('web.privacidad');
    Route::get('/terminos', 'terminos')->name('web.terminos');
    Route::get('/soporte', 'soporte')->name('web.soporte');

    // Rutas por proyecto

    /*
     *
     *
     *  Control de Obra
     *
     *
    */

    // Inicio
    Route::get('/CO', 'webCO')->name('web.webCO');
    // Descripcion
    Route::get('/CO/acerca', 'acercaCO')->name('web.acercaCO');
    // Descargas
    Route::get('/CO/descargas', 'descargasCO')->name('web.descargasCO');

    /*
     *
     *
     *  Activismo
     *
     *
    */

    // Inicio
    Route::get('/Activismo', 'webActivismo')->name('web.webActivismo');
    // Descripcion
    Route::get('/Activismo/acerca', 'acercaActivismo')->name('web.acercaActivismo');
    // Descargas
    Route::get('/Activismo/descargas', 'descargasActivismo')->name('web.descargasActivismo');

    /*
     *
     *
     *  PU
     *
     *
    */

    // Inicio
    Route::get('/PU', 'webPU')->name('web.webPU');
    // Descripcion
    Route::get('/PU/acerca', 'acercaPU')->name('web.acercaPU');
    // Descargas
    Route::get('/PU/descargas', 'descargasPU')->name('web.descargasPU');

    /*
     *
     *
     *  Requisiciones
     *
     *
    */

    // Inicio
    Route::get('/ComprasyRequisiciones', 'webRequisiciones')->name('web.webRequisiciones');
    // Descripcion
    Route::get('/ComprasyRequisiciones/acerca', 'acercaRequisiciones')->name('web.acercaRequisicionesU');
    // Descargas
    Route::get('/ComprasyRequisiciones/descargas', 'descargasRequisiciones')->name('web.descargasRequisiciones');

    /*
     *
     *
     *  TarifaDiaria
     *
     *
    */

    // Inicio
    Route::get('/TarifaDiaria', 'webTarifaDiaria')->name('web.webTarifaDiaria');
    // Descripcion
    Route::get('/TarifaDiaria/acerca', 'acercaTarifaDiaria')->name('web.acercaTarifaDiaria');
    // Descargas
    Route::get('/TarifaDiaria/descargas', 'descargasTarifaDiaria')->name('web.descargasTarifaDiaria');

    /*
     *
     *
     *  RH
     *
     *
    */

    // Inicio
    Route::get('/RH', 'webRH')->name('web.webRH');
    // Descripcion
    Route::get('/RH/acerca', 'acercaRH')->name('web.acercaRH');
    // Descargas
    Route::get('/RH/descargas', 'descargasRH')->name('web.descargasRH');


    /*
     *
     *
     *  Nomina
     *
     *
    */

    // Inicio
    Route::get('/Nomina', 'webNomina')->name('web.webNomina');
    // Descripcion
    Route::get('/Nomina/acerca', 'acercaNomina')->name('web.acercaNomina');
    // Descargas
    Route::get('/Nomina/descargas', 'descargasNomina')->name('web.descargasNomina');


    /*
     *
     *
     *  ERP
     *
     *
    */

    // Inicio
    Route::get('/noil', 'webERP')->name('web.webERP');
    // Descripcion
    Route::get('/noil/acerca', 'acercaERP')->name('web.acercaERP');
    // 
    Route::get('/noil/descargas', 'descargasERP')->name('web.descargasERP');

});

// === PANEL ADMIN ===
Route::prefix('admin')->group(function () {
    Route::get('/principal', [AdminWebController::class, 'admin_pagPrincipal'])->name('admin_pagPrincipal');
    Route::get('/dashboard', [AdminWebController::class, 'dashboard'])->name('admin_dashboard');
    Route::get('/proyectos', [AdminWebController::class, 'mostrarProyecto'])->name('admin_proyectos');
    Route::get('/usuarios', [AdminWebController::class, 'usuarios'])->name('admin_usuarios');
    Route::get('/documentacion', [AdminWebController::class, 'documentacion'])->name('admin_documentacion');
    Route::post('/proyectos/insertar', [AdminWebController::class, 'insertarProyecto'])->name('admin_proyectos_insertar');
    Route::post('/admin/proyectos/editar/{id}', [AdminWebController::class, 'updateProyecto'])->name('admin_proyectos_editar');
    Route::get('/admin/proyectos/{id}', [AdminWebController::class, 'verProyectoVersiones'])->name('admin_proyectos_ver');

    Route::get('/proyectos/{id}/versiones/agregar', [AdminWebController::class, 'adminCargarProyecto'])
    ->name('adminCargarProyecto');

// Mostrar formulario de carga de versión
Route::get('/proyectos/{id}/versiones', [AdminWebController::class, 'verProyectoVersiones'])->name('admin_proyectos_ver');

// Guardar nueva versión
Route::post('/proyecto/version/insertar', [AdminWebController::class, 'guardarVersionProyecto'])->name('adminCargarProyecto');

// (opcional) Editar versión existente
Route::post('/proyecto/version/editar/{id}', [AdminWebController::class, 'editarVersionProyecto'])->name('adminEditarVersionProyecto');

Route::post('/proyectos/version/insertar', [AdminWebController::class, 'insertarVersion'])
    ->name('admin_proyectos_version_insertar');

});


// === PERFIL ===
Route::middleware(['auth'])->group(function () {
    Route::get('/perfil', [PerfilController::class, 'edit'])->name('perfil.edit');
    Route::put('/perfil', [PerfilController::class, 'update'])->name('perfil.update');
    Route::post('/perfil/password', [PerfilController::class, 'updatePassword'])->name('perfil.password');
    Route::get('/admin/editar-perfil', [EditarPerfilController::class, 'edit'])->name('editarPerfil.edit');
    Route::put('/admin/editar-perfil', [EditarPerfilController::class, 'update'])->name('editarPerfil.update');
    Route::post('/admin/perfil/password', [EditarPerfilController::class, 'updatePassword'])->name('editarPerfil.password');
});
// === CLIENTE ===
Route::get('/clienteVistaProyecto', [ClienteVistaProyectoController::class, 'clienteVistaProyecto'])->name('clienteVistaProyecto');
Route::post('/clienteVistaProyecto', [ClienteVistaProyectoController::class, 'store'])->name('clienteVistaProyecto.store');
Route::get('/clienteDescargaProyecto', [ClienteVistaProyectoController::class, 'clienteDescargaProyecto'])->name('clienteDescargaProyecto');

Route::get('/CargarProyecto', [CargarProyectoController::class, 'adminCargarProyecto'])->name('adminCargarProyecto');
Route::post('/CargarProyecto', [CargarProyectoController::class, 'store'])->name('adminCargarProyecto.store');


// === ERROR 404 ===
Route::fallback(function () {
    return response()->view('web.error', [], 404);
});

require __DIR__ . '/auth.php';
