<?php $__env->startSection('content'); ?>
<div class="container mt-4 text-white d-flex justify-content-center">
    <div class="col-md-9"> 
        <h2 class="mb-4">Registrar nueva versión del proyecto</h2>

        
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('adminCargarProyecto')); ?>" method="POST" enctype="multipart/form-data" class="p-4 bg-dark rounded shadow">
            <?php echo csrf_field(); ?>

            
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="proyecto" class="form-label">Elegir proyecto</label>
                    <select name="IdProyecto" id="proyecto" class="form-select" required>
                        <option value="">-- Selecciona un proyecto --</option>
                        <?php $__currentLoopData = $proyectos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proyecto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($proyecto->id); ?>"><?php echo e($proyecto->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-4">
                    <label for="version" class="form-label">Versión</label>
                    <input type="text" name="version" id="version" class="form-control" placeholder="Ej. 1.0.3" required>
                </div>

                <div class="col-md-4">
                    <label for="so" class="form-label">Sistema Operativo</label>
                    <select name="sistema_operativo" id="so" class="form-select" required>
                        <option value="">-- Selecciona un sistema operativo --</option>
                        <option value="Windows">Windows</option>
                        <option value="Linux">Linux</option>
                        <option value="macOS">macOS</option>
                        <option value="Android">Android</option>
                        <option value="iOS">iOS</option>
                    </select>
                </div>
            </div>
            
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="codigo" class="form-label">Código interno</label>
                    <input type="text" name="SCodigo" id="codigo" class="form-control" placeholder="Ej. ACT-001">
                </div>
                <div class="col-md-6">
                    <label for="activo" class="form-label">Activo</label>
                    <select name="EActivo" id="activo" class="form-select">
                        <option value="Si">Sí</option>
                        <option value="No">No</option>
                    </select>
                </div>
            </div>

            
            <div class="mb-3">
                <label for="descripcion" class="form-label">Descripción</label>
                <textarea name="descripcion" id="descripcion" rows="3" class="form-control" placeholder="Describe brevemente la versión..." required></textarea>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="version_so" class="form-label">Versión del Sistema Operativo</label>
                    <input type="text" name="version_so" id="version_so" class="form-control" placeholder="Ej. Windows 11, Android 14" required>
                </div>

                <div class="col-md-6">
                    <label for="tamano" class="form-label">Tamaño</label>
                    <input type="text" name="tamano" id="tamano" class="form-control" placeholder="Ej. 25 MB" required>
                </div>
            </div>

            
            <div class="mb-3">
                <label for="resumen" class="form-label">Resumen de la versión</label>
                <textarea name="resumen" id="resumen" rows="3" class="form-control" placeholder="Breve resumen de esta versión..." required></textarea>
            </div>

            
            <div class="mb-3">
                <label for="mejoras" class="form-label">Mejoras de la versión</label>
                <textarea name="mejoras" id="mejoras" rows="3" class="form-control" placeholder="Lista de mejoras o cambios importantes..." required></textarea>
            </div>

            
            <div class="mb-3">
                <label for="requisitos" class="form-label">Requisitos</label>
                <textarea name="requisitos" id="requisitos" rows="3" class="form-control" placeholder="Indica los requisitos mínimos..." required></textarea>
            </div>

            
            <div class="mb-3">
                <label for="recomendaciones" class="form-label">Recomendaciones</label>
                <textarea name="recomendaciones" id="recomendaciones" rows="3" class="form-control" placeholder="Consejos o recomendaciones para el usuario..." required></textarea>
            </div>

            
            <div class="mb-3">
                <label for="documentacion" class="form-label">Subir documentación (PDF)</label>
                <input type="file" name="documentacion" id="documentacion" class="form-control" accept=".pdf" required>
            </div>

            
            <div class="mb-3">
                <label for="url_video" class="form-label">URL del video</label>
                <input type="url" name="url_video" id="url_video" class="form-control" placeholder="https://ejemplo.com/video" required>
            </div>

            
            <div class="text-center">
                <button type="submit" class="btn btn-primary px-5 mt-3">Guardar versión</button>
            </div>

            
            <?php if(session('file_url')): ?>
                <div class="alert alert-info mt-4">
                    <strong>Archivo cargado correctamente:</strong><br>
                    <a href="<?php echo e(session('file_url')); ?>" target="_blank" class="text-light">
                        <?php echo e(session('file_url')); ?>

                    </a>
                </div>
            <?php endif; ?>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.admin_pagPrincipal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/layouts/admin/adminCargarProyecto.blade.php ENDPATH**/ ?>