

<?php
    // Valores por defecto
    $colorPrimary = $colorPrimary ?? '#0B1C3F';
    $colorStrong = $colorStrong ?? '#07132A';
    $colorWeak = $colorWeak ?? '#162a57';
    $colorOnBrand = $colorOnBrand ?? '#fff';
    $gradient = $gradient ?? "linear-gradient(135deg, {$colorPrimary} 0%, {$colorStrong} 100%)";
    $uniqueId = $uniqueId ?? uniqid('sw-');

    // RGB del color primario para efectos CSS
    $rgb = sscanf($colorPrimary, "#%02x%02x%02x");
    $colorRgb = implode(', ', $rgb);

    // Función helper para valores seguros
    $safe = function($v, $campo, $fallback = 'No disponible') {
        $val = is_object($v) ? ($v->$campo ?? null) : ($v[$campo] ?? null);
        return ($val === null || $val === '' || $val === '-1') ? $fallback : $val;
    };

    // Función para formatear fechas
    $formatFechaCorta = function ($fecha) {
        $meses = ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'];
        try {
            $carbon = \Carbon\Carbon::parse($fecha);
            return $carbon->format('d') . ' ' . $meses[$carbon->format('n') - 1] . ' ' . $carbon->format('Y');
        } catch (\Exception $e) {
            return $fecha;
        }
    };

    // Ordenar versiones por fecha (más reciente primero)
    $sortedVersions = $versions->sortByDesc(function($v) {
        try {
            return \Carbon\Carbon::parse($safe($v, 'DFecha', '1970-01-01'));
        } catch (\Exception $e) {
            return \Carbon\Carbon::parse('1970-01-01');
        }
    });

    $latestVersion = $sortedVersions->first();
    $latestVersionNumber = $latestVersion ? $safe($latestVersion, 'SVersion', '1.0.0') : '1.0.0';
    $dropdownVersions = $sortedVersions->skip(1)->take(3);
    $hasMoreVersions = $sortedVersions->count() > 4;

    $softwareDisplayName = $safe($latestVersion ?: ($versions->first() ?? []), 'SNombreSoftware', $softwareName ?? 'NOIL - Activismo');

?>

<div class="software-card"
     style="--card-brand: <?php echo e($colorPrimary); ?>;
            --card-brand-strong: <?php echo e($colorStrong); ?>;
            --card-brand-weak: <?php echo e($colorWeak); ?>;
            --card-on-brand: <?php echo e($colorOnBrand); ?>;
            --card-gradient: <?php echo e($gradient); ?>;
            --card-brand-rgb: <?php echo e($colorRgb); ?>;">

    
    <div class="software-card__header">
        <div class="software-card__header-content">
            <div class="d-flex justify-content-between align-items-start flex-wrap gap-3">
                <div>
                    
                    <div class="d-flex align-items-center gap-3 mb-2">
                        <div class="software-card__icon">
                            <i class="<?php echo e($platformIcon); ?>"></i>
                        </div>
                        <h2 class="software-card__title mb-0"><?php echo e($platformName); ?></h2>
                    </div>
                    
                    <span class="software-card__version-badge mt-3">
                        <i class="fas fa-tag me-1"></i>v<?php echo e($latestVersionNumber); ?>

                    </span>
                </div>

                <?php if(isset($documentationUrl) || isset($videoUrl)): ?>
                <div class="software-card__links d-flex gap-2 flex-wrap">
                    <?php if(isset($documentationUrl) && $documentationUrl !== '-1' && $documentationUrl !== ''): ?>
                    <a href="<?php echo e($documentationUrl); ?>" target="_blank" class="software-card__link" title="Documentación">
                        <i class="fas fa-book"></i>
                        <span class="d-none d-md-inline">Documentación</span>
                    </a>
                    <?php endif; ?>

                    <?php if(isset($videoUrl) && $videoUrl !== '-1' && $videoUrl !== ''): ?>
                    <a href="#video-<?php echo e($uniqueId); ?>" class="software-card__link" title="Ver video">
                        <i class="fas fa-play-circle"></i>
                        <span class="d-none d-md-inline">Video</span>
                    </a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="software-card__body">
        <?php
            // Solo mostrar la información de la ÚLTIMA versión
            $latestVer = $latestVersion;
            $versionId = $safe($latestVer, 'IdVersionApp', 0);
            $versionNumber = $latestVersionNumber;
            $versionDate = $safe($latestVer, 'DFecha', now());
            $versionSO = $safe($latestVer, 'SVersionSO', 'Compatible');
            $size = $safe($latestVer, 'STamanio', '-');
            $summary = $safe($latestVer, 'SResumenVersion', 'Sin resumen disponible');
            $improvements = $safe($latestVer, 'SMejorasVersion', '');
            $requirements = $safe($latestVer, 'SRequisitos', 'Sin requisitos especificados');
            $paneId = $uniqueId . '-latest';

            // Obtener archivos de la última versión
            $files = $filesPerVersion->get($versionId, collect());
            $pdfUrl = $safe($latestVer, 'URL_PDF', '');
        ?>

        <div class="software-card__detail">
            
            <h3 class="software-card__detail-title">
                <?php echo e($softwareName); ?> <?php echo e($versionNumber); ?>

            </h3>

            <div class="software-card__detail-meta">
                <div class="software-card__meta-item">
                    <i class="fas fa-desktop"></i>
                    <span><?php echo e($versionSO); ?></span>
                </div>
                <div class="software-card__meta-item">
                    <i class="fas fa-calendar-alt"></i>
                    <span><?php echo e($formatFechaCorta($versionDate)); ?></span>
                </div>
                <?php if($size !== '-' && $size !== 'No disponible'): ?>
                <div class="software-card__meta-item">
                    <i class="fas fa-file-archive"></i>
                    <span><?php echo e($size); ?></span>
                </div>
                <?php endif; ?>
            </div>

            
            <?php if($summary !== 'Sin resumen disponible' && $summary !== 'No disponible'): ?>
            <div class="software-card__detail-section">
                <h6 class="software-card__detail-section-title">
                    <i class="fas fa-info-circle me-2"></i>Resumen
                </h6>
                <div class="software-card__detail-section-content">
                    <?php echo e($summary); ?>

                </div>
            </div>
            <?php endif; ?>

            
            <?php if($improvements !== '' && $improvements !== 'No disponible' && $improvements !== '-1'): ?>
            <div class="software-card__detail-section">
                <h6 class="software-card__detail-section-title">
                    <i class="fas fa-sparkles me-2"></i>Mejoras aplicadas
                </h6>
                <div class="software-card__detail-section-content">
                    <?php echo nl2br(e($improvements)); ?>

                </div>
            </div>
            <?php endif; ?>

            
            <?php if($requirements !== 'Sin requisitos especificados' && $requirements !== 'No disponible'): ?>
            <div class="software-card__detail-section">
                <h6 class="software-card__detail-section-title">
                    <i class="fas fa-clipboard-check me-2"></i>Requisitos del sistema
                </h6>
                <div class="software-card__detail-section-content">
                    <?php echo e($requirements); ?>

                </div>
            </div>
            <?php endif; ?>

            
            <div class="software-card__btn-group">
                                <?php if($pdfUrl !== '' && $pdfUrl !== 'No disponible' && $pdfUrl !== '-1'): ?>
                <a href="<?php echo e($pdfUrl); ?>" class="btn btn-outline-card-brand" target="_blank">
                    <i class="fas fa-file-pdf me-2"></i>Manual PDF
                </a>
                <?php endif; ?>
            </div>
        </div>

        
        <?php
            // Obtener URL de descarga de la última versión
            $latestVersionFiles = $filesPerVersion->get($safe($latestVersion, 'IdVersionApp'), collect());
            $latestDownloadUrl = $latestVersionFiles->first() ? $safe($latestVersionFiles->first(), 'URL_Ejecutable', '') : '';
        ?>

        <?php if($latestDownloadUrl !== '' && $latestDownloadUrl !== 'No disponible' && $latestDownloadUrl !== '-1'): ?>
        
        <div class="software-card__download-fixed">
            <a href="<?php echo e($latestDownloadUrl); ?>" class="btn btn-card-brand btn-lg" target="_blank">
                <i class="fas fa-download me-2"></i>Descargar v<?php echo e($latestVersionNumber); ?>

            </a>
        </div>
        <?php else: ?>
        
        <div class="software-card__download-fixed">
            <div class="software-card__download-unavailable">
                <button class="btn btn-secondary" disabled>
                    <i class="fas fa-ban me-2"></i>No disponible
                </button>
                <small class="text-muted d-block mt-1">
                    Archivo no disponible
                </small>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(isset($videoUrl) && $videoUrl !== '-1' && $videoUrl !== '' && $videoUrl !== 'No disponible'): ?>
        <div class="software-card__video-section" id="video-<?php echo e($uniqueId); ?>">
            <h4 class="software-card__video-title">
                <i class="fas fa-play-circle"></i>
                Video Tutorial
            </h4>
            <div class="software-card__video-container">
                <?php
                    // Convertir URL de YouTube a embed
                    $embedUrl = $videoUrl;
                    if (str_contains($videoUrl, 'youtube.com/watch')) {
                        parse_str(parse_url($videoUrl, PHP_URL_QUERY), $params);
                        $embedUrl = 'https://www.youtube.com/embed/' . ($params['v'] ?? '');
                    } elseif (str_contains($videoUrl, 'youtu.be/')) {
                        $embedUrl = str_replace('youtu.be/', 'youtube.com/embed/', $videoUrl);
                    }
                ?>
                <iframe
                    src="<?php echo e($embedUrl); ?>"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                    allowfullscreen>
                </iframe>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/components/software-card.blade.php ENDPATH**/ ?>