<?php $__env->startSection('content'); ?>
    <div class="container py-4">
        <div class="row g-4">

            
            <div class="col-12 col-xl-6 mb-4 mb-xl-0">
                <h4 class="fw-bold mb-3 text-white">
                    <i class="fa-solid fa-desktop me-2"></i> Aplicación de Escritorio
                </h4>

                <div class="card border-0 shadow-sm platform-card windows animate-fade-in">
                    
                    <div class="card-header header-brand text-white">
                        <div class="d-flex flex-wrap justify-content-between align-items-center">
                            <div class="d-flex align-items-center gap-2">
                                <i class="fa-brands fa-windows"></i>
                                <h5 class="mb-0">Windows</h5>
                            </div>
                            <div class="text-end">
                                <small class="d-block opacity-75">última versión</small>
                                <strong>v1.0.0</strong>
                            </div>
                        </div>
                    </div>

                    
                    <div class="card-body">
                        <div class="row g-3">
                            
                            <div class="col-12 col-md-5 col-lg-4">
                                <div class="versions-box rounded-3 p-2">
                                    <ul class="nav nav-pills flex-md-column gap-2" role="tablist"
                                        aria-label="Versiones de Windows">
                                        <li class="nav-item">
                                            <button type="button" class="nav-link version-btn active w-100 text-start"
                                                data-bs-toggle="pill" data-bs-target="#win-100" role="tab"
                                                aria-controls="win-100" aria-selected="true">
                                                v1.0.0
                                                <span class="badge bg-light text-dark ms-1">10 Ago 2025</span>
                                            </button>
                                        </li>
                                        <li class="nav-item">
                                            <button type="button" class="nav-link version-btn w-100 text-start"
                                                data-bs-toggle="pill" data-bs-target="#win-099" role="tab"
                                                aria-controls="win-099" aria-selected="false">
                                                v0.9.9
                                                <span class="badge bg-light text-dark ms-1">25 Jul 2025</span>
                                            </button>
                                        </li>
                                        <li class="nav-item">
                                            <button type="button" class="nav-link version-btn w-100 text-start"
                                                data-bs-toggle="pill" data-bs-target="#win-098" role="tab"
                                                aria-controls="win-098" aria-selected="false">
                                                v0.9.8
                                                <span class="badge bg-light text-dark ms-1">30 Jun 2025</span>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            
                            <div class="col-12 col-md-7 col-lg-8">
                                <div class="detail-box rounded-3">
                                    <div class="tab-content">
                                        
                                        <div class="tab-pane fade show active" id="win-100" role="tabpanel"
                                            aria-labelledby="win-100">
                                            <h6 class="mb-1 text-brand">Windows v1.0.0</h6>
                                            <small class="d-block mb-3 text-muted">Fecha: 10 Ago 2025 · Tamaño: 82
                                                MB</small>
                                            <ul class="mb-3">
                                                <li>Corrección de errores y mejoras de rendimiento.</li>
                                                <li>Primer build estable público.</li>
                                            </ul>
                                            <div class="d-flex flex-wrap gap-2">
                                                <a href="#" class="btn btn-brand">Descargar instalador (.exe)</a>
                                                <button type="button" class="btn btn-outline-brand" data-bs-toggle="modal"
                                                    data-bs-target="#modalNotas100">
                                                    Notas de versión
                                                </button>
                                            </div>
                                        </div>

                                        
                                        <div class="tab-pane fade" id="win-099" role="tabpanel" aria-labelledby="win-099">
                                            <h6 class="mb-1 text-brand">Windows v0.9.9</h6>
                                            <small class="d-block mb-3 text-muted">Fecha: 25 Jul 2025 · Tamaño: 81
                                                MB</small>
                                            <ul class="mb-3">
                                                <li>Optimización del módulo de reportes.</li>
                                                <li>Mejoras en la velocidad de arranque.</li>
                                            </ul>
                                            <div class="d-flex flex-wrap gap-2">
                                                <a href="#" class="btn btn-brand">Descargar instalador (.exe)</a>
                                                <button type="button" class="btn btn-outline-brand" data-bs-toggle="modal"
                                                    data-bs-target="#modalNotas099">
                                                    Notas de versión
                                                </button>
                                            </div>
                                        </div>

                                        
                                        <div class="tab-pane fade" id="win-098" role="tabpanel" aria-labelledby="win-098">
                                            <h6 class="mb-1 text-brand">Windows v0.9.8</h6>
                                            <small class="d-block mb-3 text-muted">Fecha: 30 Jun 2025 · Tamaño: 79
                                                MB</small>
                                            <ul class="mb-3">
                                                <li>Compatibilidad con Windows 11 24H2.</li>
                                                <li>Mejoras menores en interfaz.</li>
                                            </ul>
                                            <div class="d-flex flex-wrap gap-2">
                                                <a href="#" class="btn btn-brand">Descargar instalador (.exe)</a>
                                                <button type="button" class="btn btn-outline-brand" data-bs-toggle="modal"
                                                    data-bs-target="#modalNotas098">
                                                    Notas de versión
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">
                                    <small class="text-muted d-block">Requisitos: Windows 10 o superior, 4 GB RAM.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-12 col-xl-6">
                <h4 class="fw-bold mb-3 mt-xl-0 mt-4 text-white">
                    <i class="fa-solid fa-mobile-screen me-2"></i> Aplicación Móvil
                </h4>

                <div id="mobileCard" class="card border-0 shadow-sm mb-4 platform-card mobile animate-fade-in"
                    data-platform="ios">
                    
                    <div class="card-header header-brand">
                        <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
                            <div class="d-flex align-items-center gap-2">
                                <i class="fa-solid fa-mobile-screen"></i>
                                <h5 class="mb-0">Sistemas operativos móviles</h5>
                            </div>

                            <ul class="nav nav-pills platform-switch" id="platformTabs" role="tablist"
                                aria-label="Plataformas móviles">
                                <li class="nav-item me-1" role="presentation">
                                    <button class="nav-link active" id="tab-ios" data-bs-toggle="tab"
                                        data-bs-target="#pane-ios" type="button" role="tab"
                                        aria-controls="pane-ios" aria-selected="true">
                                        <i class="fa-brands fa-apple me-1"></i> iOS
                                    </button>
                                </li>
                                <li class="nav-item ms-1" role="presentation">
                                    <button class="nav-link" id="tab-android" data-bs-toggle="tab"
                                        data-bs-target="#pane-android" type="button" role="tab"
                                        aria-controls="pane-android" aria-selected="false">
                                        <i class="fa-brands fa-android me-1"></i> Android
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>

                    
                    <div class="card-body">
                        <div class="tab-content">

                            
                            <div class="tab-pane fade show active" id="pane-ios" role="tabpanel"
                                aria-labelledby="tab-ios">
                                <div class="row g-3">
                                    
                                    <div class="col-12 col-md-5 col-lg-4">
                                        <div class="versions-box rounded-3 p-2">
                                            <ul class="nav nav-pills flex-md-column gap-2" role="tablist"
                                                aria-label="Versiones de iOS">
                                                <li class="nav-item">
                                                    <button type="button"
                                                        class="nav-link version-btn active w-100 text-start"
                                                        data-bs-toggle="pill" data-bs-target="#ios-210" role="tab"
                                                        aria-controls="ios-210" aria-selected="true">
                                                        v2.1.0
                                                        <span class="badge bg-light text-dark ms-1">12 Ago 2025</span>
                                                    </button>
                                                </li>
                                                <li class="nav-item">
                                                    <button type="button" class="nav-link version-btn w-100 text-start"
                                                        data-bs-toggle="pill" data-bs-target="#ios-205" role="tab"
                                                        aria-controls="ios-205" aria-selected="false">
                                                        v2.0.5
                                                        <span class="badge bg-light text-dark ms-1">18 Jul 2025</span>
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    
                                    <div class="col-12 col-md-7 col-lg-8">
                                        <div class="detail-box rounded-3">
                                            <div class="tab-content">
                                                
                                                <div class="tab-pane fade show active" id="ios-210" role="tabpanel"
                                                    aria-labelledby="ios-210">
                                                    <h6 class="mb-1 text-brand">iOS v2.1.0</h6>
                                                    <small class="d-block mb-3 text-muted">Fecha: 12 Ago 2025 · Tamaño: 58
                                                        MB</small>
                                                    <ul class="mb-3">
                                                        <li>Nuevos widgets y mejoras de estabilidad.</li>
                                                        <li>Optimización de consumo en segundo plano.</li>
                                                    </ul>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="btn btn-brand">Abrir en App Store</a>
                                                        <button type="button" class="btn btn-outline-brand"
                                                            data-bs-toggle="modal" data-bs-target="#modalNotasIOS210">
                                                            Notas de versión
                                                        </button>
                                                    </div>
                                                </div>

                                                
                                                <div class="tab-pane fade" id="ios-205" role="tabpanel"
                                                    aria-labelledby="ios-205">
                                                    <h6 class="mb-1 text-brand">iOS v2.0.5</h6>
                                                    <small class="d-block mb-3 text-muted">Fecha: 18 Jul 2025 · Tamaño: 56
                                                        MB</small>
                                                    <ul class="mb-3">
                                                        <li>Corrección en el sistema de notificaciones push.</li>
                                                        <li>Mejoras menores en interfaz.</li>
                                                    </ul>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="btn btn-brand">Abrir en App Store</a>
                                                        <button type="button" class="btn btn-outline-brand"
                                                            data-bs-toggle="modal" data-bs-target="#modalNotasIOS205">
                                                            Notas de versión
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr class="my-4">
                                            <small class="text-muted d-block">Requisitos: iOS 14 o superior.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="tab-pane fade" id="pane-android" role="tabpanel" aria-labelledby="tab-android">
                                <div class="row g-3">
                                    
                                    <div class="col-12 col-md-5 col-lg-4">
                                        <div class="versions-box rounded-3 p-2">
                                            <ul class="nav nav-pills flex-md-column gap-2" role="tablist"
                                                aria-label="Versiones de Android">
                                                <li class="nav-item">
                                                    <button type="button"
                                                        class="nav-link version-btn active w-100 text-start"
                                                        data-bs-toggle="pill" data-bs-target="#and-210" role="tab"
                                                        aria-controls="and-210" aria-selected="true">
                                                        v2.1.0
                                                        <span class="badge bg-light text-dark ms-1">12 Ago 2025</span>
                                                    </button>
                                                </li>
                                                <li class="nav-item">
                                                    <button type="button" class="nav-link version-btn w-100 text-start"
                                                        data-bs-toggle="pill" data-bs-target="#and-207" role="tab"
                                                        aria-controls="and-207" aria-selected="false">
                                                        v2.0.7
                                                        <span class="badge bg-light text-dark ms-1">20 Jul 2025</span>
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    
                                    <div class="col-12 col-md-7 col-lg-8">
                                        <div class="detail-box rounded-3">
                                            <div class="tab-content">
                                                
                                                <div class="tab-pane fade show active" id="and-210" role="tabpanel"
                                                    aria-labelledby="and-210">
                                                    <h6 class="mb-1 text-brand">Android v2.1.0</h6>
                                                    <small class="d-block mb-3 text-muted">Fecha: 12 Ago 2025 · Tamaño: 62
                                                        MB</small>
                                                    <ul class="mb-3">
                                                        <li>Soporte Android 15 y optimizaciones de rendimiento.</li>
                                                        <li>Mejor manejo de permisos en tiempo de ejecución.</li>
                                                    </ul>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="btn btn-brand">Abrir en Google Play</a>
                                                        <button type="button" class="btn btn-outline-brand"
                                                            data-bs-toggle="modal" data-bs-target="#modalNotasAND210">
                                                            Notas de versión
                                                        </button>
                                                    </div>
                                                </div>

                                                
                                                <div class="tab-pane fade" id="and-207" role="tabpanel"
                                                    aria-labelledby="and-207">
                                                    <h6 class="mb-1 text-brand">Android v2.0.7</h6>
                                                    <small class="d-block mb-3 text-muted">Fecha: 20 Jul 2025 · Tamaño: 60
                                                        MB</small>
                                                    <ul class="mb-3">
                                                        <li>Corrección de cierres inesperados en dispositivos de gama media.
                                                        </li>
                                                        <li>Parche de seguridad incluido.</li>
                                                    </ul>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="btn btn-brand">Abrir en Google Play</a>
                                                        <button type="button" class="btn btn-outline-brand"
                                                            data-bs-toggle="modal" data-bs-target="#modalNotasAND207">
                                                            Notas de versión
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr class="my-4">
                                            <small class="text-muted d-block">Requisitos: Android 8.0 o superior.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    
    <div class="modal fade" id="modalNotas100" tabindex="-1" aria-labelledby="modalNotas100Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card windows">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotas100Label">
                        <i class="fa-brands fa-windows me-2"></i>Notas de versión — Windows v1.0.0 (10 Ago 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 82 MB · Requisitos: Windows 10+ · 4 GB RAM</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Corrección de errores y mejoras de rendimiento.</li>
                        <li>Primer build estable público.</li>
                    </ul>
                    <h6 class="mb-2">Notas</h6>
                    <ul class="mb-0">
                        <li>Compatibilidad UAC mejorada.</li>
                        <li>Binario firmado con certificado actualizado.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Si vienes de v0.9.x, no necesitas desinstalar antes de actualizar.</small>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNotas099" tabindex="-1" aria-labelledby="modalNotas099Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card windows">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotas099Label">
                        <i class="fa-brands fa-windows me-2"></i>Notas de versión — Windows v0.9.9 (25 Jul 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 81 MB · Requisitos: Windows 10+ · 4 GB RAM</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Optimización del módulo de reportes.</li>
                        <li>Mejoras en la velocidad de arranque.</li>
                    </ul>
                    <h6 class="mb-2">Notas</h6>
                    <ul class="mb-0">
                        <li>Tiempo de inicio reducido 30% en equipos con HDD.</li>
                        <li>Correcciones menores en traducciones.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Release candidate previo a 1.0.0.</small>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNotas098" tabindex="-1" aria-labelledby="modalNotas098Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card windows">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotas098Label">
                        <i class="fa-brands fa-windows me-2"></i>Notas de versión — Windows v0.9.8 (30 Jun 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 79 MB · Requisitos: Windows 10+ · 4 GB RAM</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Compatibilidad con Windows 11 24H2.</li>
                        <li>Mejoras menores en interfaz.</li>
                    </ul>
                    <h6 class="mb-2">Notas</h6>
                    <ul class="mb-0">
                        <li>Tema de alto contraste actualizado.</li>
                        <li>Corrección en accesos directos del menú Inicio.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Recomendado actualizar a v0.9.9 o superior.</small>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalNotasIOS210" tabindex="-1" aria-labelledby="modalNotasIOS210Label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card ios">
                <div class="modal-header header-brand">
                    <h5 class="modal-title" id="modalNotasIOS210Label">
                        <i class="fa-brands fa-apple me-2"></i>Notas de versión — iOS v2.1.0 (12 Ago 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 58 MB · Requisitos: iOS 14+</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Nuevos widgets para pantalla de inicio y bloqueo.</li>
                        <li>Mejoras de estabilidad y menor consumo energético.</li>
                    </ul>
                    <h6 class="mb-2">Notas</h6>
                    <ul class="mb-0">
                        <li>Soporte actualizado para notificaciones críticas.</li>
                        <li>Mejoras de accesibilidad (VoiceOver).</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Recomendado para todos los dispositivos compatibles.</small>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNotasIOS205" tabindex="-1" aria-labelledby="modalNotasIOS205Label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card ios">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotasIOS205Label">
                        <i class="fa-brands fa-apple me-2"></i>Notas de versión — iOS v2.0.5 (18 Jul 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 56 MB · Requisitos: iOS 14+</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Solución a la entrega irregular de notificaciones.</li>
                        <li>Mejoras menores en la UI de ajustes.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Compatibilidad desde iPhone 6s en adelante.</small>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNotasAND210" tabindex="-1" aria-labelledby="modalNotasAND210Label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card android">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotasAND210Label">
                        <i class="fa-brands fa-android me-2"></i>Notas de versión — Android v2.1.0 (12 Ago 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 62 MB · Requisitos: Android 8.0+</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Compatibilidad con Android 15.</li>
                        <li>Optimización de rendimiento y menor uso de memoria.</li>
                    </ul>
                    <h6 class="mb-2">Notas</h6>
                    <ul class="mb-0">
                        <li>Mejor manejo de permisos para ubicación en segundo plano.</li>
                        <li>Actualización de librerías de seguridad.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Se recomienda actualizar desde v2.0.x.</small>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNotasAND207" tabindex="-1" aria-labelledby="modalNotasAND207Label"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card android">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotasAND207Label">
                        <i class="fa-brands fa-android me-2"></i>Notas de versión — Android v2.0.7 (20 Jul 2025)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">Tamaño: 60 MB · Requisitos: Android 8.0+</div>
                    <h6 class="mb-2">Cambios</h6>
                    <ul class="mb-3">
                        <li>Corrección de cierres inesperados (crash fix).</li>
                        <li>Parche de seguridad mensual integrado.</li>
                    </ul>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <small class="text-muted">Compatibilidad mejorada con fabricantes populares.</small>
                </div>
            </div>
        </div>
    </div>

    
    <style>
        /* Animación simple */
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .animate-fade-in {
            animation: fadeIn 0.8s ease-out both;
        }

        .platform-card.windows.animate-fade-in {
            animation-delay: .1s;
        }

        .platform-card.mobile.animate-fade-in {
            animation-delay: .2s;
        }

        /* Variables por defecto */
        .platform-card {
            --brand: #0B1C3F;
            /* base */
            --brand-strong: #07132A;
            --brand-weak: #162a57;
            --on-brand: #fff;
            /* texto sobre header/botones */
        }

        /* Header común */
        .header-brand {
            background-color: var(--brand);
            color: var(--on-brand);
        }

        .header-brand * {
            color: inherit;
        }

        /* Cajas y botones basados en variables */
        .versions-box {
            background: var(--brand);
        }

        .text-brand {
            color: var(--brand);
        }

        /* ===== botones de acción (mejor contraste por defecto) */
        .btn-brand {
            background: var(--brand-strong);
            color: #fff;
            border: none;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        .btn-brand:hover,
        .btn-brand:active {
            background: var(--brand);
            color: #fff;
        }

        .btn-outline-brand {
            border: 1px solid var(--brand-strong);
            color: var(--brand-strong);
            background: transparent;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .08) inset;
        }

        .btn-outline-brand:hover,
        .btn-outline-brand:active {
            background: var(--brand-strong);
            color: #fff;
            border-color: var(--brand-strong);
        }

        /* Pills de versiones: con sombreado */
        .nav-pills .nav-link.version-btn {
            background: transparent;
            color: #eaeaea;
            border: 1px solid rgba(255, 255, 255, .12);
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        .nav-pills .nav-link.version-btn:hover:not(.active) {
            background: var(--brand-weak);
            color: #fff;
            border-color: var(--brand-weak);
        }

        .nav-pills .nav-link.version-btn.active {
            background: var(--brand-strong) !important;
            color: #fff !important;
            border: 2px solid #fff !important;
        }

        /* ================== Skins ================== */
        /* Windows (cyan) */
        .platform-card.windows {
            --brand: #0AA1C4;
            --brand-strong: #064E60;
            --brand-weak: #087A96;
            --on-brand: #fff;
        }

        /* ====== Móvil: cambia por data-platform ====== */
        /* iOS (gris claro) */
        .platform-card.mobile[data-platform="ios"] {
            --brand: #E9ECEF;
            --brand-strong: #CFD4DA;
            --brand-weak: #F8F9FA;
            --on-brand: #212529;
        }

        /* Contraste iOS:
           - títulos interiores (.text-brand) pasan a oscuro
           - botones usan fondo oscuro para no "perderse"
           - lista de versiones en fondo claro con bordes y sombras acordes
        */
        .platform-card.mobile[data-platform="ios"] .text-brand {
            color: #212529;
        }

        .platform-card.mobile[data-platform="ios"] .btn-brand {
            background: #212529;
            /* mucho más contraste que #CFD4DA */
            color: #fff;
        }

        .platform-card.mobile[data-platform="ios"] .btn-brand:hover {
            background: #111;
        }

        .platform-card.mobile[data-platform="ios"] .btn-outline-brand {
            border-color: #212529;
            color: #212529;
        }

        .platform-card.mobile[data-platform="ios"] .btn-outline-brand:hover {
            background: #212529;
            color: #fff;
        }

        /* versiones (iOS) con buen contraste y sombra coherente */
        .platform-card.mobile[data-platform="ios"] .versions-box .nav-link.version-btn {
            color: #212529;
            border-color: rgba(0, 0, 0, .2);
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .10);
        }

        .platform-card.mobile[data-platform="ios"] .versions-box .nav-link.version-btn:hover:not(.active) {
            background: #F8F9FA;
            color: #212529;
            border-color: rgba(0, 0, 0, .3);
        }

        .platform-card.mobile[data-platform="ios"] .versions-box .nav-link.version-btn.active {
            background: #212529 !important;
            /* activo oscuro para máxima legibilidad */
            color: #fff !important;
            border: 2px solid #212529 !important;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        /* Selector de pestañas (iOS/Android) con sombreado relacionado a la tarjeta */
        .platform-card.mobile .platform-switch .nav-link {
            background: transparent;
            color: var(--on-brand);
            border: 1px solid rgba(255, 255, 255, .22);
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        .platform-card.mobile[data-platform="ios"] .platform-switch .nav-link {
            border-color: rgba(0, 0, 0, .20);
            color: #212529;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .10);
        }

        .platform-card.mobile .platform-switch .nav-link.active {
            background: var(--on-brand);
            color: var(--brand);
            border-color: var(--on-brand);
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .22);
        }

        /* En iOS, activo debe ser oscuro con texto claro para no perderse */
        .platform-card.mobile[data-platform="ios"] .platform-switch .nav-link.active {
            background: #212529;
            color: #fff;
            border-color: #212529;
        }

        /* Android (verde) */
        .platform-card.mobile[data-platform="android"] {
            --brand: #1E7E34;
            --brand-strong: #155724;
            --brand-weak: #2D8E45;
            --on-brand: #fff;
        }

        /* ================== Modales iOS ================== */
        .modal-content.platform-card.ios {
            /* paleta consistente con la tarjeta iOS */
            --brand: #E9ECEF;
            --brand-strong: #212529;
            /* usamos oscuro para máximo contraste */
            --brand-weak: #F8F9FA;
            --on-brand: #212529;
            background: #fff;
            color: #212529;
            box-shadow: 0 .75rem 2rem rgba(0, 0, 0, .2);
        }

        .modal-content.platform-card.ios .header-brand {
            background: #212529;
            /* header oscuro + texto claro */
            color: #fff;
        }

        .modal-content.platform-card.ios .header-brand * {
            color: inherit;
        }

        .modal-content.platform-card.ios .modal-body {
            color: #212529;
        }

        .modal-content.platform-card.ios .btn-brand {
            background: #212529;
            color: #fff;
            border: none;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        .modal-content.platform-card.ios .btn-brand:hover,
        .modal-content.platform-card.ios .btn-brand:active {
            background: #111;
            color: #fff;
        }

        .modal-content.platform-card.ios .btn-outline-brand {
            border: 1px solid #212529;
            color: #212529;
            background: transparent;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .08) inset;
        }

        .modal-content.platform-card.ios .btn-outline-brand:hover,
        .modal-content.platform-card.ios .btn-outline-brand:active {
            background: #212529;
            color: #fff;
            border-color: #212529;
        }

        /* ================== Modales Android ================== */
        .modal-content.platform-card.android {
            /* paleta consistente con la tarjeta Android */
            --brand: #1E7E34;
            --brand-strong: #155724;
            --brand-weak: #2D8E45;
            --on-brand: #fff;
            background: #fff;
            color: #1b1b1b;
            box-shadow: 0 .75rem 2rem rgba(0, 0, 0, .2);
        }

        .modal-content.platform-card.android .header-brand {
            background: #1E7E34;
            /* header verde + texto claro */
            color: #fff;
        }

        .modal-content.platform-card.android .header-brand * {
            color: inherit;
        }

        .modal-content.platform-card.android .btn-brand {
            background: #155724;
            color: #fff;
            border: none;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .18);
        }

        .modal-content.platform-card.android .btn-brand:hover,
        .modal-content.platform-card.android .btn-brand:active {
            background: #1E7E34;
            color: #fff;
        }

        .modal-content.platform-card.android .btn-outline-brand {
            border: 1px solid #155724;
            color: #155724;
            background: transparent;
            box-shadow: 0 .35rem 1rem rgba(0, 0, 0, .08) inset;
        }

        .modal-content.platform-card.android .btn-outline-brand:hover,
        .modal-content.platform-card.android .btn-outline-brand:active {
            background: #155724;
            color: #fff;
            border-color: #155724;
        }

        /* tipografías auxiliares del modal */
        .modal-content.platform-card.ios .small,
        .modal-content.platform-card.android .small {
            opacity: .85;
        }

        /* ============ WINDOWS — SKIN: CYAN MIDNIGHT ============ */
.platform-card.windows.skin-midnight{
  --brand:#00BBD4;          /* cyan acento */
  --brand-weak:#12CFE6;     /* hover claro */
  --brand-strong:#01343B;   /* base profunda */
  --on-brand:#EFFFFF;       /* texto sobre brand oscuro */
  --ink-strong:#001725;     /* texto en fondos claros */
  --edge:#63F5FF;           /* brillo/borde */
  background: #001E22;
  border-radius: .9rem;
  box-shadow: 0 .75rem 2rem rgba(0,0,0,.35);
}

/* Header con efecto midnight + borde glow */
.platform-card.windows.skin-midnight .header-brand{
  background: radial-gradient(120% 140% at 0% 0%, #015660 0%, #01343B 55%, #012227 100%);
  color: var(--on-brand);
  border-bottom: 2px solid var(--edge);
}
.platform-card.windows.skin-midnight .header-brand *{ color:inherit; }

/* Panel de versiones en tono profundo */
.platform-card.windows.skin-midnight .versions-box{
  background:#052B31;
  border:1px solid rgba(255,255,255,.08);
  box-shadow: inset 0 0 0 1px rgba(255,255,255,.03);
}

/* Pills: borde glow, activo invertido */
.platform-card.windows.skin-midnight .nav-pills .nav-link.version-btn{
  background: rgba(0,0,0,.18);
  color:#DDFBFF;
  border:1px solid rgba(99,245,255,.25);
  box-shadow: 0 .4rem 1.1rem rgba(0,0,0,.28);
}
.platform-card.windows.skin-midnight .nav-pills .nav-link.version-btn:hover:not(.active){
  background:#014D56;                 /* hover oscuro */
  color:#EFFFFF;
  border-color:var(--edge);
}
.platform-card.windows.skin-midnight .nav-pills .nav-link.version-btn.active{
  background:#00BBD4 !important;      /* activo cyan vivo */
  color:#001725 !important;           /* texto oscuro para contraste */
  border:2px solid #FFFFFF !important;
  box-shadow: 0 .6rem 1.4rem rgba(0,0,0,.34);
}
.platform-card.windows.skin-midnight .nav-pills .nav-link.version-btn .badge{
  background:#FFFFFF; color:#004B54; font-weight:600;
}

/* Texto destacado dentro del detalle */
.platform-card.windows.skin-midnight .text-brand{ color:#12CFE6; }
.platform-card.windows.skin-midnight .detail-box hr{ border-top-color:rgba(255,255,255,.08); }
.platform-card.windows.skin-midnight .detail-box small.text-muted{ color:#7AC7CF !important; }

/* Botones: sólido y outline con glow */
.platform-card.windows.skin-midnight .btn-brand{
  background:#00BBD4; color:#001725;
  border:1px solid var(--edge);
  box-shadow: 0 .45rem 1.2rem rgba(0,0,0,.35);
}
.platform-card.windows.skin-midnight .btn-brand:hover{ background:#12CFE6; }

.platform-card.windows.skin-midnight .btn-outline-brand{
  border:1px solid var(--edge); color:#9CF7FF; background:transparent;
}
.platform-card.windows.skin-midnight .btn-outline-brand:hover{
  background:#01343B; color:#EFFFFF; border-color:#9CF7FF;
}

/* ============ MODAL – CYAN MIDNIGHT ============ */
.modal-content.platform-card.windows.skin-midnight{
  background:#031A1D; color:#EFFFFF; border:none;
  box-shadow: 0 .9rem 2.2rem rgba(0,0,0,.45);
}
.modal-content.platform-card.windows.skin-midnight .header-brand{
  background: linear-gradient(135deg,#015660 0%, #013E46 60%, #012B30 100%);
  color:#EFFFFF; border-bottom:2px solid var(--edge);
}
.modal-content.platform-card.windows.skin-midnight .header-brand *{ color:inherit; }

.modal-content.platform-card.windows.skin-midnight .btn-brand{
  background:#00BBD4; color:#001725; border:1px solid var(--edge);
}
.modal-content.platform-card.windows.skin-midnight .btn-brand:hover{ background:#12CFE6; }

.modal-content.platform-card.windows.skin-midnight .btn-outline-brand{
  border:1px solid var(--edge); color:#9CF7FF; background:transparent;
}
.modal-content.platform-card.windows.skin-midnight .btn-outline-brand:hover{
  background:#01343B; color:#EFFFFF;
}

.modal-content.platform-card.windows.skin-midnight .badge{
  background:#00BBD4; color:#001725; border:1px solid rgba(0,0,0,.06);
}


    </style>


    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileCard = document.getElementById('mobileCard');
            const tabs = document.getElementById('platformTabs');
            if (!mobileCard || !tabs) return;

            tabs.addEventListener('shown.bs.tab', function(ev) {
                const id = ev.target.id;
                if (id === 'tab-ios') mobileCard.setAttribute('data-platform', 'ios');
                if (id === 'tab-android') mobileCard.setAttribute('data-platform', 'android');
            });
        });
    </script>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/web/descargasCO.blade.php ENDPATH**/ ?>