<?php $__env->startSection('content'); ?>
    <div class="page-fade">

        <div class="container my-4">

            
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm overflow-hidden rounded-3">
                            <div class="row g-0 align-items-stretch">
                                
                                <div class="col-12 col-lg-6 p-4 p-lg-5 d-flex">
                                    <div class="my-auto">
                                        <h5 class="text-uppercase small fw-semibold text-muted mb-2">Alcances de Control de
                                            Obra</h5>
                                        <h3 class="fw-bold mb-3">NOIL Control de Obra</h3>
                                        <p class="mb-0">
                                            NOIL Control de Obra es una aplicación integral para seguimiento de obra que
                                            centraliza, automatiza y optimiza procesos de planeación, ejecución y
                                            documentación en proyectos de construcción. Permite el seguimiento en tiempo
                                            real de avances programados, físicos y financieros, asegurando la trazabilidad
                                            de recursos y la medición de eficiencia en cada etapa del proyecto.
                                        </p>
                                    </div>
                                </div>
                                
                                <div class="col-12 col-lg-6">
                                    <div class="media-box h-100">
                                        <img src="<?php echo e(asset('img/acerca/acerca-01.jpg')); ?>" class="media-contain"
                                            alt="NOIL Control de Obra - Alcances">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 app-section-card">
                            <div class="card-body p-4 p-lg-5">

                                
                                <div class="row justify-content-center text-center mb-3">
                                    <div class="col-12">
                                        <h5 class="text-uppercase small fw-semibold text-muted mb-1">
                                            Módulo de Control de Obra
                                        </h5>
                                        <h3 class="fw-bold mb-0">Áreas de Aplicación</h3>
                                    </div>
                                </div>

                                
                                <div class="row g-4 justify-content-center">
                                    
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media">
                                                <img src="<?php echo e(asset('img/acerca/acerca-02.jpg')); ?>" class="app-card__img"
                                                    alt="Desarrollo inmobiliario">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Desarrollo inmobiliario</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Controla tiempos, costos y avances en proyectos
                                                    habitacionales y complejos residenciales.</p>
                                            </div>
                                        </article>
                                    </div>

                                    
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media">
                                                <img src="<?php echo e(asset('img/acerca/acerca-03.jpg')); ?>" class="app-card__img"
                                                    alt="Infraestructura">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Infraestructura</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Supervisa carreteras, puentes y sistemas de drenaje con
                                                    transparencia y eficiencia.</p>
                                            </div>
                                        </article>
                                    </div>

                                    
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media">
                                                <img src="<?php echo e(asset('img/acerca/acerca-04.jpg')); ?>" class="app-card__img"
                                                    alt="Industrial">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Industrial</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Gestiona plantas, fábricas y naves logísticas optimizando
                                                    recursos y productividad.</p>
                                            </div>
                                        </article>
                                    </div>

                                    
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <article
                                            class="app-card position-relative rounded-3 overflow-hidden shadow-sm h-100">
                                            <div class="app-card__media">
                                                <img src="<?php echo e(asset('img/acerca/acerca-05.jpg')); ?>" class="app-card__img"
                                                    alt="Urbanización">
                                            </div>
                                            <div class="app-card__overlay"></div>
                                            <div class="app-card__title">
                                                <h5 class="mb-0 text-white text-shadow">Urbanización</h5>
                                            </div>
                                            <div class="app-card__content">
                                                <p class="mb-0">Administra pavimentación, alumbrado y parques con control
                                                    de avance y presupuesto.</p>
                                            </div>
                                        </article>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 overflow-hidden">
                            <div class="row g-0">
                                
                                <div class="col-12 p-4 p-lg-5">
                                    <h5 class="text-uppercase small fw-semibold text-muted mb-1">Características</h5>
                                    <p class="mb-4">
                                        NOIL control de obra centraliza la información en un solo sitio para su consulta en
                                        todo momento, reduce re‑trabajos optimizando capturas simultáneas e íntegras y
                                        ahorra tiempo y recursos desde la ejecución hasta la estimación, permitiendo generar
                                        y estimar en tiempo los trabajos ejecutados.
                                    </p>

                                    <ul class="list-unstyled m-0 feature-list" id="featureList" aria-live="polite">
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>múltiples proyectos y frentes de trabajo</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>control de acceso a información por usuario</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>control automatizado y estimaciones a tiempo</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>reducción de errores y re‑trabajos</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3 mb-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>ahorro de tiempo y recursos</span>
                                        </li>
                                        <li class="d-flex align-items-start gap-3">
                                            <span class="feature-check" aria-hidden="true"></span>
                                            <span>acceso a información en todo momento</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="mb-5">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm rounded-3 overflow-hidden">

                            
                            <div class="card-header bg-white text-center py-4">
                                <h3 class="fw-bold mb-0">Segmentos del Software</h3>
                            </div>

                            <div class="row g-0 align-items-stretch">
                                
                                <div class="col-12 col-lg-5 order-lg-1">
                                    <div class="media-box h-100 media-box--tall bg-white">
                                        <img src="<?php echo e(asset('img/acerca/acerca-06.jpg')); ?>" class="media-contain"
                                            alt="Segmentos del Software - Vista vertical">
                                    </div>
                                </div>

                                
                                <div class="col-12 col-lg-7 p-3 p-lg-4 order-lg-2">
                                    <div class="list-group list-group-flush shadow-sm rounded-3 overflow-hidden"
                                        role="tablist">

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Planificación</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Con la creación de programas de obra y medición de avances, se garantiza
                                                contar con información a tiempo para la toma de decisiones.
                                            </p>
                                        </div>

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Precios unitarios</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Adaptabilidad e interacción con plantillas de explosión de insumos, base
                                                para un control integral desde el presupuesto.
                                            </p>
                                        </div>

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Reportes en sitio</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Captura de información desde el sitio de los trabajos, permitiendo la
                                                medición de avances y datos adicionales.
                                            </p>
                                        </div>

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Facturación y cobros</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Mejora los tiempos de entrega de estimaciones y su facturación, con
                                                posibilidad de interfaces para clientes.
                                            </p>
                                        </div>

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Informes ejecutivos</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Dashboards e indicadores sobre costos reales, recursos utilizados y más,
                                                para la toma de decisiones.
                                            </p>
                                        </div>

                                        
                                        <button
                                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center seg-btn"
                                            aria-expanded="false">
                                            <span class="fw-semibold">Inventario de Obra</span>
                                            <i class="fa-solid fa-chevron-down small"></i>
                                        </button>
                                        <div class="seg-content" role="region">
                                            <p class="mb-0 text-body">
                                                Inventario real por proyecto y trazabilidad de materiales y servicios desde
                                                la requisición hasta su colocación en obra.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            
            <section class="mb-4">
                <div class="row justify-content-center">
                    <div class="col-12 col-xl-10">
                        <div class="card border-0 shadow-sm overflow-hidden rounded-3">
                            <div class="row g-0 align-items-stretch">
                                
                                <div class="col-12 col-lg-6 p-4 p-lg-5 d-flex">
                                    <div class="my-auto">
                                        <h3 class="fw-bold mb-3">APP Móvil</h3>
                                        <p class="mb-0">
                                            Aplicación móvil de fácil uso que garantiza la captura de información desde el
                                            sitio de los trabajos, con conectividad online/offline y sincronización con
                                            dispositivos desktop. Ahorra tiempo en la consolidación de volúmenes para
                                            generadores y estimaciones.
                                        </p>
                                    </div>
                                </div>
                                
                                <div class="col-12 col-lg-6">
                                    <div class="media-box h-100 bg-white app-mobile">
                                        <img src="<?php echo e(asset('img/acerca/acerca-07.png')); ?>" class="media-contain"
                                            alt="App móvil NOIL - horizontal">
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>

    </div>

    
    <style>
        :root {
            --dark-1: #0A0A2A;
            --dark-2: #13063E;
            --accent-1: #4a3b9e;
            --cyan-1: #33E1F7;
            --cyan-2: #00C2E8;
            --cyan-3: #0AA1C4;
            --ink-1: #001725;
        }

        /* fondo base + animación */
        body,
        .page-fade {
            background-color: var(--dark-2);
            color: #f8f9fa;
            animation: fadeInPage .6s ease forwards;
            opacity: 0;
        }

        @keyframes fadeInPage {
            to {
                opacity: 1
            }
        }

        /* tarjetas claras para contraste con fondo oscuro */
        .card {
            background: #fff;
            color: #212529
        }

        /* contenedor sección en tarjeta */
        .app-section-card {
            background: #ffffff;
            box-shadow: 0 20px 50px rgba(19, 6, 62, .08), 0 6px 18px rgba(19, 6, 62, .05);
            border-radius: 1rem;
        }

        /* media boxes: contener imagen (no deformar) */
        .media-box {
            position: relative;
            width: 100%;
            height: 100%;
            min-height: 260px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #0b0b0b;
        }

        .media-box--tall {
            min-height: 360px
        }

        .media-contain {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
            width: 100%;
            height: auto;
            display: block;
        }

        /* áreas de aplicación */
        .app-card {
            min-height: 230px;
            background: #000
        }

        .app-card__media {
            position: absolute;
            inset: 0;
            display: flex
        }

        .app-card__img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            opacity: .85
        }

        .app-card__overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(180deg, rgba(0, 0, 0, .35) 0%, rgba(0, 0, 0, .7) 100%);
            transition: opacity .25s ease;
        }

        .app-card__title {
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            padding: 1rem;
            z-index: 2
        }

        .text-shadow {
            text-shadow: 0 2px 10px rgba(0, 0, 0, .55)
        }

        .app-card__content {
            position: absolute;
            inset: 0;
            color: #fff;
            z-index: 2;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            opacity: 0;
            transform: translateY(6px);
            transition: opacity .25s ease, transform .25s ease;
            background: rgba(0, 0, 0, .38);
        }

        .app-card:hover .app-card__overlay {
            opacity: .25
        }

        .app-card:hover .app-card__content {
            opacity: 1;
            transform: translateY(0)
        }

        /* características – checklist (más lento) */
        .feature-check {
            width: 22px;
            height: 22px;
            border-radius: 6px;
            background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            box-shadow: 0 6px 18px rgba(0, 194, 232, .35);
            position: relative;
            flex: 0 0 22px;
            transform: scale(.85);
            opacity: .25;
            transition: transform .45s ease, opacity .45s ease;
        }

        .feature-check::after {
            content: "";
            position: absolute;
            inset: 0;
            background: #001725;
            opacity: 0;
            transition: opacity .45s ease;
            mask: url("data:image/svg+xml,%3Csvg viewBox='0 0 16 16' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill='white' d='M6.173 14.727a1 1 0 0 1-.768-.36l-3.8-4.5a1 1 0 1 1 1.538-1.275l3.02 3.578L12.8 2.467a1 1 0 1 1 1.666 1.11L7.08 14.184a1 1 0 0 1-.754.48 1 1 0 0 1-.153.01z'/%3E%3C/svg%3E") center/14px 14px no-repeat;
            -webkit-mask: url("data:image/svg+xml,%3Csvg viewBox='0 0 16 16' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill='white' d='M6.173 14.727a1 1 0 0 1-.768-.36l-3.8-4.5a1 1 0 1 1 1.538-1.275l3.02 3.578L12.8 2.467a1 1 0 1 1 1.666 1.11L7.08 14.184a1 1 0 0 1-.754.48 1 1 0 0 1-.153.01z'/%3E%3C/svg%3E") center/14px 14px no-repeat;
        }

        .feature-checked .feature-check {
            opacity: 1;
            transform: scale(1)
        }

        .feature-checked .feature-check::after {
            opacity: 1
        }

        /* —— sección 4 (segmentos) —— */
        .list-group-item {
            background: #fff;
            color: #212529;
            font-size: 1.1rem;
        }

        .seg-btn {
            background: #fff;
            padding: 1.25rem 1.5rem;
        }

        .seg-btn span {
            font-size: 1.2rem;
            line-height: 1.5;
        }

        .seg-btn .fa-chevron-down {
            transition: transform .25s ease;
            font-size: 1rem;
        }

        .seg-btn .fa-chevron-down.rotate {
            transform: rotate(180deg)
        }

        .seg-content {
            max-height: 0;
            overflow: hidden;
            padding: 0 1.25rem;
            background: #fdfdfd;
            border-top: 1px solid #e5e5e5;
            transition: max-height .35s ease, padding .35s ease;
        }

        .seg-content p {
            color: #212529;
            font-size: 1.1rem;
            line-height: 1.7;
        }

        .seg-content.open {
            padding: 1.1rem 1.25rem;
            max-height: 400px;
        }

        /* ajustar tamaño de la imagen de la sección app móvil */
        .media-box.app-mobile img {
            max-width: 75%;
            /* reduce al 75% del ancho disponible */
            height: auto;
            margin: 0 auto;
            /* centra horizontalmente */
            display: block;
        }


        /* responsivo */
        @media (max-width:991.98px) {
            .media-box {
                min-height: 220px
            }

            .media-box--tall {
                min-height: 300px
            }
        }

        @media (min-width:992px) {
            .media-box--tall {
                min-height: 380px
            }
        }
    </style>

    
    <script>
        // checklist: animación escalonada al entrar en viewport (más lenta)
        (() => {
            const list = document.getElementById('featureList');
            if (!list) return;
            const items = Array.from(list.children);

            const io = new IntersectionObserver(entries => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        items.forEach((li, idx) => {
                            setTimeout(() => li.classList.add('feature-checked'), 220 * idx);
                        });
                        io.disconnect();
                    }
                });
            }, {
                threshold: .25
            });

            io.observe(list);
        })();

        // segmentos: toggle suave + animación
        (() => {
            const btns = document.querySelectorAll('.seg-btn');

            btns.forEach(btn => {
                btn.addEventListener('click', () => {
                    const content = btn.nextElementSibling;
                    if (!content || !content.classList) return;

                    const chevron = btn.querySelector('.fa-chevron-down');
                    const willOpen = !content.classList.contains('open');

                    // cerrar otros abiertos
                    document.querySelectorAll('.seg-content.open').forEach(c => c.classList.remove(
                        'open'));
                    document.querySelectorAll('.seg-btn .fa-chevron-down.rotate').forEach(i => i
                        .classList.remove('rotate'));

                    if (willOpen) {
                        content.classList.add('open');
                        chevron?.classList.add('rotate');
                    } else {
                        content.classList.remove('open');
                        chevron?.classList.remove('rotate');
                    }
                });
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/web/acerca.blade.php ENDPATH**/ ?>