<?php $__env->startSection('content'); ?>
<?php
    use Carbon\Carbon;

    // ===== Helpers =====
    $meses = ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'];

    $formatFechaCorta = function ($fecha) use ($meses) {
        if (!$fecha) return 'No disponible';
        try {
            $dt = Carbon::parse($fecha);
            $dia = $dt->format('d');
            $mes = $meses[(int)$dt->format('m') - 1] ?? '';
            $anio = $dt->format('Y');
            return "{$dia} {$mes} {$anio}";
        } catch (\Throwable $e) {
            return (string) $fecha;
        }
    };

    $safe = function($v, $campo, $fallback = 'No disponible') {
        $val = data_get($v, $campo);
        return ($val === null || $val === '' || $val === '-1') ? $fallback : $val;
    };

    // Colecciones seguras
    $versiones = collect($resultadosVersion ?? []);
    $archivosPorVersion = collect($archivosPorVersion ?? []);

    // Ordenar por fecha DESC
    $versionesOrdenadas = $versiones->sortByDesc(function($v){
        return Carbon::parse($v->DFecha ?? '1900-01-01');
    })->values();

    // Última versión
    $ultima = $versionesOrdenadas->first();
?>

<div class="container py-4">
    <div class="row justify-content-center">
        
        <div class="col-12 col-lg-10 col-xl-8">
            <h4 class="fw-bold mb-3 ps-2 text-white text-left">
                <i class="fa-solid fa-desktop me-2"></i> Aplicación de Escritorio
            </h4>

            <div class="card border-0 shadow-sm platform-card windows animate-fade-in mx-auto" style="max-width: 980px;">
                
                <div class="card-header header-brand text-white">
                    <div class="d-flex flex-wrap justify-content-between align-items-center">
                        <div class="d-flex align-items-center gap-2">
                            <i class="fa-brands fa-windows icon-align" aria-hidden="true"></i>
                            <h5 class="mb-0">Windows</h5>
                        </div>
                        <div class="text-end">
                            <small class="d-block opacity-75">última versión</small>
                            <strong><?php echo e($ultima ? $safe($ultima, 'SVersion', '—') : '—'); ?></strong>
                        </div>
                    </div>
                </div>

                
                <div class="card-body">

                    
                    <?php if($versionesOrdenadas->isEmpty()): ?>
                        <div class="d-flex align-items-center justify-content-center text-muted" style="min-height: 260px;">
                            <span class="fs-5">No hay versiones para mostrar</span>
                        </div>
                    <?php else: ?>
                    
                    <div class="row g-3 justify-content-center">

                        
                        <div class="col-12 col-md-5 col-lg-4">
                            <div class="versions-box rounded-3 p-2">
                                <ul class="nav nav-pills flex-md-column gap-2" role="tablist" aria-label="Versiones de Windows">
                                    <?php $__currentLoopData = $versionesOrdenadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $paneId = 'win-' . preg_replace('/[^a-zA-Z0-9]+/', '', $safe($v,'SVersion','x'));
                                        ?>
                                        <li class="nav-item">
                                            <button
                                                type="button"
                                                class="nav-link version-btn w-100 text-start <?php echo e($idx===0 ? 'active' : ''); ?>"
                                                data-bs-toggle="pill"
                                                data-bs-target="#<?php echo e($paneId); ?>"
                                                role="tab"
                                                aria-controls="<?php echo e($paneId); ?>"
                                                aria-selected="<?php echo e($idx===0 ? 'true' : 'false'); ?>"
                                            >
                                                <?php echo e($safe($v,'SVersion','—')); ?>

                                                <span class="badge bg-light text-dark ms-1">
                                                    <?php echo e($formatFechaCorta($v->DFecha ?? null)); ?>

                                                </span>
                                            </button>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        
                        <div class="col-12 col-md-7 col-lg-8">
                            <div class="detail-box rounded-3">
                                <div class="tab-content">
                                    <?php $__currentLoopData = $versionesOrdenadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $paneId      = 'win-' . preg_replace('/[^a-zA-Z0-9]+/', '', $safe($v,'SVersion','x'));
                                            $versionSO   = $safe($v,'SVersionSO','No disponible');
                                            $fechaCorta  = $formatFechaCorta($v->DFecha ?? null);
                                            $tam         = $safe($v,'STamanio','No disponible');
                                            $resumen     = $safe($v,'SResumenVersion','Sin resumen');

                                            // Archivos vinculados por IdVersionApp
                                            $grpKey      = isset($v->IdVersionApp) ? (string)$v->IdVersionApp : '';
                                            $grupo       = $archivosPorVersion->get($grpKey, collect());
                                            $fila        = $grupo instanceof \Illuminate\Support\Collection ? $grupo->first() : (is_array($grupo) ? (object)($grupo[0] ?? []) : $grupo);

                                            $urlExe      = $fila->URL_Ejecutable ?? null;
                                            $urlScript   = $fila->URL_Scripts   ?? null;

                                            $hasNotas    = !in_array($v->SMejorasVersion ?? '-1', [null,'','-1']);
                                        ?>

                                        <div class="tab-pane fade <?php echo e($idx===0 ? 'show active' : ''); ?>" id="<?php echo e($paneId); ?>" role="tabpanel" aria-labelledby="<?php echo e($paneId); ?>">
                                            <h6 class="mb-1 text-brand">Windows <?php echo e($safe($v,'SVersion','—')); ?></h6>

                                            <div class="mb-2 small text-muted">
                                                <strong>Versión de SO:</strong> <?php echo e($versionSO); ?>

                                            </div>
                                            <div class="mb-2 small text-muted">
                                                <strong>Fecha y tamaño:</strong> <?php echo e($fechaCorta); ?> · <?php echo e($tam); ?>

                                            </div>
                                            <div class="mb-3">
                                                <strong>Resumen de versión:</strong>
                                                <div class="mt-1"><?php echo e($resumen); ?></div>
                                            </div>

                                            
                                            <div class="d-flex flex-wrap gap-2">
                                                <?php if($urlExe): ?>
                                                    <a href="<?php echo e($urlExe); ?>" class="btn btn-brand" target="_blank" rel="noopener">
                                                        Descargar .exe
                                                    </a>
                                                <?php endif; ?>

                                                <?php if($hasNotas): ?>
                                                    <button type="button" class="btn btn-outline-brand" data-bs-toggle="modal" data-bs-target="#modalNotas-<?php echo e($paneId); ?>">
                                                        Notas de versión
                                                    </button>
                                                <?php endif; ?>

                                                <?php if($urlScript): ?>
                                                    <a href="<?php echo e($urlScript); ?>" class="btn btn-outline-secondary" target="_blank" rel="noopener">
                                                        Script
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <hr class="my-4">
                                <?php if($ultima && !in_array($ultima->SRequisitos ?? '-1', [null,'','-1'])): ?>
                                    <small class="text-muted d-block text-left">
                                        Requisitos: <?php echo e($ultima->SRequisitos); ?>

                                    </small>
                                <?php else: ?>
                                    <small class="text-muted d-block text-left">
                                        Requisitos: Windows 10 o superior, 4 GB RAM.
                                    </small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__currentLoopData = $versionesOrdenadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $paneId   = 'win-' . preg_replace('/[^a-zA-Z0-9]+/', '', $safe($v,'SVersion','x'));
        $mejoras  = $safe($v,'SMejorasVersion','');
        $hasNotas = !in_array($v->SMejorasVersion ?? '-1', [null,'','-1']);
    ?>
    <?php if($hasNotas): ?>
    <div class="modal fade" id="modalNotas-<?php echo e($paneId); ?>" tabindex="-1" aria-labelledby="modalNotas-<?php echo e($paneId); ?>-Label" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 platform-card windows">
                <div class="modal-header header-brand text-white">
                    <h5 class="modal-title" id="modalNotas-<?php echo e($paneId); ?>-Label">
                        <i class="fa-brands fa-windows me-2"></i>Notas de versión — Windows <?php echo e($safe($v,'SVersion','—')); ?> (<?php echo e($formatFechaCorta($v->DFecha ?? null)); ?>)
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 small text-muted">
                        Tamaño: <?php echo e($safe($v,'STamanio','No disponible')); ?>

                        <?php $req = $safe($v,'SRequisitos',''); ?>
                        <?php if($req && $req !== 'No disponible'): ?> · Requisitos: <?php echo e($req); ?> <?php endif; ?>
                    </div>
                    <h6 class="mb-2">Cambios / Mejoras</h6>
                    <div class="mb-0"><?php echo nl2br(e($mejoras)); ?></div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<style>
    /* Animación simple */
    @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
    .animate-fade-in { animation: fadeIn 0.8s ease-out both; }

    /* Variables por defecto */
    .platform-card {
        --brand: #0B1C3F;        /* base */
        --brand-strong: #07132A;
        --brand-weak: #162a57;
        --on-brand: #fff;        /* texto sobre header/botones */
    }

    /* Header común */
    .header-brand { background-color: var(--brand); color: var(--on-brand); }
    .header-brand * { color: inherit; }

    /* Alineación fina del ícono del header */
    .header-brand .icon-align{
        display:inline-flex;
        width:1.35rem;
        height:1.35rem;
        align-items:center;
        justify-content:center;
        line-height:1;
        vertical-align:middle;
        transform: translateY(1px);
    }

    /* Cajas y botones basados en variables */
    .versions-box { background: var(--brand); padding: .5rem; }
    .text-brand { color: var(--brand); }

    .btn-brand {
        background: var(--brand-strong);
        color: #fff;
        border: none;
        box-shadow: 0 .35rem 1rem rgba(0,0,0,.18);
    }
    .btn-brand:hover, .btn-brand:active { background: var(--brand); color: #fff; }

    .btn-outline-brand {
        border: 1px solid var(--brand-strong);
        color: var(--brand-strong);
        background: transparent;
        box-shadow: 0 .35rem 1rem rgba(0,0,0,.08) inset;
    }
    .btn-outline-brand:hover, .btn-outline-brand:active {
        background: var(--brand-strong);
        color: #fff;
        border-color: var(--brand-strong);
    }

    /* Pills de versiones */
    .nav-pills .nav-link.version-btn {
        background: transparent;
        color: #eaeaea;
        border: 1px solid rgba(255,255,255,.12);
        box-shadow: 0 .35rem 1rem rgba(0,0,0,.18);
    }
    .nav-pills .nav-link.version-btn:hover:not(.active) {
        background: var(--brand-weak);
        color: #fff;
        border-color: var(--brand-weak);
    }
    .nav-pills .nav-link.version-btn.active {
        background: var(--brand-strong) !important;
        color: #fff !important;
        border: 2px solid #fff !important;
    }

    /* ================== Windows (cyan) ================== */
    .platform-card.windows {
        --brand: #0AA1C4;
        --brand-strong: #064E60;
        --brand-weak: #087A96;
        --on-brand: #fff;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/web/descargasActivismo.blade.php ENDPATH**/ ?>