
<?php
    use Illuminate\Support\Str;
    use Illuminate\Support\Facades\Route;

    // 1) Contexto normalizado (primer segmento del path, en minúsculas)
    $ctx = Str::lower(request()->segment(1) ?? '');

    // 2) Mapa de contexto -> rutas (keys SIEMPRE en minúsculas)
    $map = [
        'co' => [
            'home'      => 'web.webCO',
            'acerca'    => 'web.acercaCO',
            'descargas' => 'web.descargasCO',
            'acercaTxt' => 'Acerca de Noil Control de Obra',
        ],
        'activismo' => [
            'home'      => 'web.webActivismo',
            'acerca'    => 'web.acercaActivismo',
            'descargas' => 'web.descargasActivismo',
            'acercaTxt' => 'Acerca de Activismo',
        ],
        'pu' => [
            'home'      => 'web.webPU',
            'acerca'    => 'web.acercaPU',
            'descargas' => 'web.descargasPU',
            'acercaTxt' => 'Acerca de PU',
        ],
        'requisiciones' => [
            'home'      => 'web.webRequisiciones',
            'acerca'    => 'web.acercaRequisiciones',
            'descargas' => 'web.descargasRequisiciones',
            'acercaTxt' => 'Acerca de Requisiciones',
        ],
        'tarifadiaria' => [
            'home'      => 'web.webTarifaDiaria',
            'acerca'    => 'web.acercaTarifaDiaria',
            'descargas' => 'web.descargasTarifaDiaria',
            'acercaTxt' => 'Acerca de Tarifa Diaria',
        ],
        'rh' => [
            'home'      => 'web.webRH',
            'acerca'    => 'web.acercaRH',
            'descargas' => 'web.descargasRH',
            'acercaTxt' => 'Acerca de RH',
        ],
        'nomina' => [
            'home'      => 'web.webNomina',
            'acerca'    => 'web.acercaNomina',
            'descargas' => 'web.descargasNomina',
            'acercaTxt' => 'Acerca de Nómina',
        ],
        'noil' => [
            'home'      => 'web.webERP',
            'acerca'    => 'web.acercaERP',
            'descargas' => 'web.descargasERP',
            'acercaTxt' => 'Acerca de Noil ERP',
        ]
    ];

    // 3) Selección de rutas válidas según contexto (si no existe el key, no hay contexto)
    $ctxHasMap = array_key_exists($ctx, $map);
    $homeRoute      = $ctxHasMap && isset($map[$ctx]['home'])      && Route::has($map[$ctx]['home'])      ? $map[$ctx]['home']      : null;
    $acercaRoute    = $ctxHasMap && isset($map[$ctx]['acerca'])    && Route::has($map[$ctx]['acerca'])    ? $map[$ctx]['acerca']    : null;
    $descargasRoute = $ctxHasMap && isset($map[$ctx]['descargas']) && Route::has($map[$ctx]['descargas']) ? $map[$ctx]['descargas'] : null;

    $acercaText = $ctxHasMap ? ($map[$ctx]['acercaTxt'] ?? 'Acerca de') : null;

    // 4) Fallback del logo
    $logoHref = $homeRoute
        ? route($homeRoute)
        : (Route::has('web.inicio') ? route('web.inicio') : '#');
?>

<nav class="navbar navbar-expand-md navbar-dark" style="background-color:#0A0A2A; width:100%;">
    <div class="container-xl align-items-center">

        
        <a class="navbar-brand <?php echo e($logoHref === '#' ? 'disabled' : ''); ?>" href="<?php echo e($logoHref); ?>"
           <?php if($logoHref === '#'): ?> aria-disabled="true" tabindex="-1" <?php endif; ?>>
            <img src="<?php echo e(asset('img/software_noil_blanco.png')); ?>" alt="Noil Control de Obra" class="img-fluid"
                 style="max-height:50px; width:auto;">
        </a>

        
        <button class="navbar-toggler d-md-none ms-auto border-0" type="button" id="hamburgerBtn"
            aria-controls="navLinks" aria-expanded="false" aria-label="toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        
        <div id="navLinks" class="ms-md-auto d-none d-md-block nav-slide">
            <ul class="navbar-nav flex-column flex-md-row align-items-md-center gap-md-0 ps-3 ps-md-0">

                
                <?php if($homeRoute): ?>
                    <li class="nav-item d-none">
                        <a class="nav-link text-white <?php echo e(request()->routeIs($homeRoute) ? 'fw-bold' : ''); ?>"
                           href="<?php echo e(route($homeRoute)); ?>">
                            Inicio
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($acercaRoute): ?>
                    <li class="nav-item d-none">
                        <a class="nav-link text-white <?php echo e(request()->routeIs($acercaRoute) ? 'fw-bold' : ''); ?>"
                           href="<?php echo e(route($acercaRoute)); ?>">
                           <?php echo e($acercaText); ?>

                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($descargasRoute): ?>
                    <li class="nav-item d-none">
                        <a class="nav-link text-white <?php echo e(request()->routeIs($descargasRoute) ? 'fw-bold' : ''); ?>"
                           href="<?php echo e(route($descargasRoute)); ?>">
                            Descargas
                        </a>
                    </li>
                <?php endif; ?>

                
                <li class="nav-item">
                    <a class="nav-link text-white <?php echo e(request()->routeIs('web.contacto') ? 'fw-bold' : ''); ?>"
                        href="<?php echo e(route('web.contacto')); ?>">
                        Contacto
                    </a>
                </li>

                
                <?php if(auth()->guard()->check()): ?>
                    <li class="nav-item ms-md-3 mt-2 mt-md-0">
                        <a href="<?php echo e(route('admin_pagPrincipal')); ?>"
                           class="nav-btn d-flex align-items-center gap-2 px-2 py-1 text-decoration-none">
                            <div class="icon-badge-sm d-flex justify-content-center align-items-center rounded-2" aria-hidden="true">
                                <i class="fa-solid fa-user fa-sm"></i>
                            </div>
                        </a>
                    </li>
                <?php else: ?>
                    
                    <li class="nav-item dropdown ms-md-3 mt-2 mt-md-0 d-none">
                        <a href="#"
                           class="nav-btn d-flex align-items-center gap-2 px-2 py-1 text-decoration-none dropdown-toggle"
                           id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            <div class="icon-badge-sm d-flex justify-content-center align-items-center rounded-2" aria-hidden="true">
                                <i class="fa-solid fa-user fa-sm"></i>
                            </div>
                            <span class="d-md-none text-white">Acceso</span>
                        </a>

                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?php echo e(route('login')); ?>">Iniciar Sesión</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('register')); ?>">Registrarse</a></li>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<style>
    /* paleta */
    :root {
        --dark-1: #0A0A2A;
        --dark-2: #13063E;
        --accent-1: #4a3b9e;
        --cyan-1: #73ecf4;
        --cyan-2: #61e2ea;
        --cyan-3: #3eb5bd;
        --ink-1: #001725;
    }

    /* badge más pequeño */
    .icon-badge-sm {
        width: 28px;
        height: 28px;
        background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
        color: var(--ink-1);
        box-shadow: 0 4px 12px rgba(0, 194, 232, .3);
        flex-shrink: 0;
    }

    /* botón compacto */
    .nav-btn {
        border: 0;
        border-radius: 0;
        box-shadow: 0 2px 6px rgba(0, 0, 0, .08);
        transition: transform .2s ease, box-shadow .2s ease;
    }
    .nav-btn:hover { transform: translateY(-1px); box-shadow: 0 6px 14px rgba(0, 0, 0, .12); }

    /* animación slide en < md */
    .nav-slide {
        overflow: hidden;
        height: 0;
        opacity: 0;
        transition: height 250ms ease, opacity 200ms ease;
    }
    .nav-slide.open { opacity: 1; }

    @media (max-width: 767.98px) {
        #navLinks { width: 100%; }
        #navLinks.open { margin-top: .5rem; }
    }

    @media (min-width: 768px) {
        .nav-slide {
            overflow: visible;
            height: auto !important;
            opacity: 1 !important;
            margin-top: 0 !important;
            width: auto !important;
        }
    }

    /* Estilos para el dropdown en DESKTOP */
    @media (min-width: 768px) {
        .dropdown-menu {
            background-color: var(--dark-2);
            border: 1px solid var(--accent-1);
            right: 0 !important;
            left: auto !important;
            border-radius: 8px;
        }
        .dropdown-item { color: white; padding: 8px 16px; }
        .dropdown-item:hover { background-color: var(--accent-1); color: white; }
    }

    .dropdown-toggle::after { display: none !important; }

    /* ESTILOS PARA LA LISTA DE LOGIN EN MÓVIL */
    @media (max-width: 767.98px) {
        .mobile-login-options {
            width: 100%;
            margin-top: 8px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding-top: 12px;
        }
        .mobile-login-header {
            padding: 12px 16px;
            background-color: rgba(255, 255, 255, 0.05);
            border-radius: 6px;
            margin-bottom: 8px;
        }
        .mobile-login-list { list-style: none; padding: 0; margin: 0; }
        .mobile-login-item {
            display: block;
            padding: 12px 20px;
            color: white;
            text-decoration: none;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            transition: background-color 0.2s ease;
            background-color: rgba(255, 255, 255, 0.03);
        }
        .mobile-login-item:last-child { border-bottom: none; }
        .mobile-login-item:hover { background-color: var(--accent-1); color: white; }

        .dropdown-menu {
            position: static !important;
            float: none;
            width: 100%;
            background-color: transparent;
            border: 0;
            box-shadow: none;
            padding-top: 0;
        }
        .dropdown-item {
            background-color: rgba(255, 255, 255, 0.05);
            color: white;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .dropdown-item:hover { background-color: var(--accent-1); color: white; }
        .dropdown-menu.show { display: block; }
        .dropdown-toggle::after { display: none; }

        /* Ocultar el dropdown de desktop en móvil */
        .nav-item.d-none.d-md-block { display: none !important; }
    }

    @media (min-width: 768px) {
        .mobile-login-options { display: none !important; }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const btn = document.getElementById('hamburgerBtn');
    const nav = document.getElementById('navLinks');
    if (!btn || !nav) return;

    const MD = 768;
    const isDesktop = () => window.innerWidth >= MD;

    const setOpenHeight = () => {
        nav.style.height = 'auto';
        const h = nav.scrollHeight;
        nav.style.height = '0px';
        requestAnimationFrame(() => { nav.style.height = h + 'px'; });
    };

    const show = () => {
        nav.classList.remove('d-none');
        nav.classList.add('d-block', 'open', 'w-100');
        setOpenHeight();
        btn.setAttribute('aria-expanded', 'true');
    };

    const hide = () => {
        const current = nav.scrollHeight;
        nav.style.height = current + 'px';
        requestAnimationFrame(() => { nav.style.height = '0px'; });
        btn.setAttribute('aria-expanded', 'false');
        const onEnd = (e) => {
            if (e.propertyName !== 'height') return;
            nav.classList.remove('open', 'd-block', 'w-100');
            nav.classList.add('d-none');
            nav.removeEventListener('transitionend', onEnd);
        };
        nav.addEventListener('transitionend', onEnd);
    };

    btn.addEventListener('click', () => {
        const opened = nav.classList.contains('open');
        opened ? hide() : show();
    });

    // Cerrar menú al hacer click en cualquier enlace (en móvil)
    nav.addEventListener('click', (e) => {
        if (!isDesktop() && e.target.closest('a')) {
            if (nav.classList.contains('open')) hide();
        }
    });

    const sync = () => {
        nav.style.height = '';
        if (isDesktop()) {
            nav.classList.remove('d-none', 'w-100');
            nav.classList.add('d-block', 'open');
            btn.setAttribute('aria-expanded', 'true');
        } else {
            nav.classList.remove('open', 'd-block');
            nav.classList.add('d-none');
            btn.setAttribute('aria-expanded', 'false');
        }
    };

    window.addEventListener('resize', () => {
        const wasMobileOpen = !isDesktop() && nav.classList.contains('open');
        sync();
        if (wasMobileOpen) setOpenHeight();
    });

    sync();

    // Dropdown móvil (si decides mostrarlo)
    const dropdownToggle = document.getElementById('userDropdown');
    if (dropdownToggle) {
        dropdownToggle.addEventListener('click', (e) => {
            if (window.innerWidth < 768) {
                e.preventDefault();
                const menu = dropdownToggle.nextElementSibling;
                menu.classList.toggle('show');
            }
        });
    }
});
</script>
<?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/layouts/guest/partials/navbar.blade.php ENDPATH**/ ?>