<?php $__env->startSection('content'); ?>
    <?php
        // ===== Helpers de presentación =====
        $titleCase = function ($s) {
            if ($s === null || $s === '' || $s === '-1') return 'No disponible';
            $s = trim($s);
            $isAllCaps = mb_strtoupper($s, 'UTF-8') === $s;
            return $isAllCaps ? mb_convert_case(mb_strtolower($s, 'UTF-8'), MB_CASE_TITLE, 'UTF-8') : $s;
        };

        $textOrNA = function ($s) {
            return ($s === null || $s === '' || $s === '-1') ? 'No disponible' : $s;
        };

        $computeRoute = function ($nombre) {
            $n = mb_strtolower(trim((string) $nombre), 'UTF-8');
            if ($n === 'control de obra' || $n === 'control de  obra' || $n === 'control deobra' || $n === 'co' ) {
                return route('web.descargasCO');
            }
            if ($n === 'activismo') {
                return route('web.descargasActivismo');
            }
            return '#'; // fallback a pestañas internas o detalle futuro
        };

        $hasImage = function ($url) {
            return !(is_null($url) || $url === '' || $url === '-1');
        };

        // Icono por sistema operativo
        $osIcon = function ($codigo, $nombre = '') {
            $c = mb_strtolower(trim((string) $codigo), 'UTF-8');
            if ($c === '' || $c === '-1') {
                $c = mb_strtolower(trim((string) $nombre), 'UTF-8');
            }
            if (str_contains($c, 'win'))     return 'fa-brands fa-windows';
            if (str_contains($c, 'mac') ||
                str_contains($c, 'osx') ||
                str_contains($c, 'ios'))     return 'fa-brands fa-apple';
            if (str_contains($c, 'linux'))   return 'fa-brands fa-linux';
            if (str_contains($c, 'android')) return 'fa-brands fa-android';
            return 'fa-solid fa-desktop';
        };

        // Fecha amigable
        $fmtDate = function ($fecha) {
            try { return \Carbon\Carbon::parse($fecha)->format('d M Y'); }
            catch (\Throwable $e) { return '—'; }
        };

        // Evitar notices si no llegan estas colecciones
        $lastUpdatedByProject   = isset($lastUpdatedByProject)   ? $lastUpdatedByProject   : [];
        $latestVersionByProject = isset($latestVersionByProject) ? $latestVersionByProject : [];
        $platformsByProject     = isset($platformsByProject)     ? $platformsByProject     : [];
    ?>

    <div class="page-fade">
        <div class="container my-4">
            
            <div class="row justify-content-center">
                <div class="col-12 col-md-10 col-lg-8">
                    <div class="card shadow-sm border-0 rounded-bottom">

                        
                        <div class="card-header support-strip text-dark rounded-top">
                            <div class="text-center p-2">
                                <h4 class="support-title fw-semibold mb-1">
                                    <span aria-hidden="true"></span>
                                    Centro de Descargas
                                </h4>
                                <p class="support-subtitle mb-0">Encuentra nuestros softwares y sus versiones disponibles.</p>
                            </div>
                        </div>

                        
                        <div class="card-body p-0">
                            <div class="p-3 p-md-4">

                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <span class="small text-muted">Haz clic en un software para ver detalles y descargas</span>
                                </div>

                                <div class="row g-3 g-md-4">
                                    <?php $__empty_1 = true; $__currentLoopData = $resultadosProyectos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            $idProyecto   = $proy->IdProyecto ?? null;
                                            $nombre       = $titleCase($proy->SNombreProyecto ?? null);
                                            $descripcion  = $textOrNA($proy->SDescripcion ?? null);
                                            $imgUrl       = $proy->URL_imagen ?? null;
                                            $activo       = trim((string)($proy->EActivo ?? 'No')) === 'Si';

                                            $isDisabled   = !$activo; // Bloquear navegación si no está activo
                                            $badgeText    = $activo ? 'Disponible' : 'No disponible';
                                            $badgeClass   = $activo ? 'bg-success-subtle text-success border border-success'
                                                                    : 'bg-warning-subtle text-warning border border-warning';

                                            // Sólo calcular ruta si está activo
                                            $routeUrl     = $isDisabled ? '#' : $computeRoute($proy->SNombreProyecto ?? '');

                                            // Última actualización de cualquier OS (fecha) — OCULTA MÁS ABAJO
                                            $ultAct       = $idProyecto && isset($lastUpdatedByProject[$idProyecto])
                                                            ? $fmtDate($lastUpdatedByProject[$idProyecto])
                                                            : '—';

                                            // Última versión global (SVersion + fecha)
                                            $latestObj    = $idProyecto && isset($latestVersionByProject[$idProyecto]) ? $latestVersionByProject[$idProyecto] : null;
                                            $ultVersion   = $latestObj ? ($latestObj->SVersion ?? '—') : '—';
                                            $ultVersionF  = $latestObj ? $fmtDate($latestObj->DFecha ?? null) : '—';

                                            // Plataformas con variantes de SO (Windows 11, 10, 7 ...)
                                            $plats        = ($idProyecto && isset($platformsByProject[$idProyecto]))
                                                            ? $platformsByProject[$idProyecto] : collect();
                                        ?>

                                        <div class="col-12">
                                            <div class="software-item card hoverable <?php echo e($isDisabled ? 'is-disabled' : ''); ?>"
                                                <?php if (! ($isDisabled)): ?> data-route="<?php echo e($routeUrl); ?>" <?php endif; ?>
                                                data-disabled="<?php echo e($isDisabled ? '1' : '0'); ?>"
                                                role="<?php echo e($isDisabled ? 'group' : 'button'); ?>"
                                                aria-disabled="<?php echo e($isDisabled ? 'true' : 'false'); ?>"
                                                <?php if($isDisabled): ?> tabindex="-1" <?php endif; ?>
                                                aria-label="Ir a descargas de <?php echo e($nombre); ?>">
                                                <div class="thumb-wrap">
                                                    <?php if($hasImage($imgUrl)): ?>
                                                        <img src="<?php echo e($imgUrl); ?>"
                                                             alt="<?php echo e($nombre); ?>"
                                                             class="thumb-img"
                                                             loading="lazy"
                                                             onerror="this.closest('.thumb-wrap').innerHTML = `<div class='thumb-placeholder'>No disponible</div>`;">
                                                    <?php else: ?>
                                                        <div class="thumb-placeholder">No disponible</div>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="card-body d-flex flex-column">
                                                    <div class="d-flex justify-content-between align-items-start gap-2">
                                                        <div class="d-flex align-items-center gap-2">
                                                            <h6 class="mb-0"><?php echo e($nombre); ?></h6>
                                                            <span class="badge <?php echo e($badgeClass); ?>"><?php echo e($badgeText); ?></span>
                                                        </div>

                                                        
                                                        <div class="text-end small text-muted lh-sm">
                                                            <div>Última versión: <strong><?php echo e($ultVersion); ?></strong></div>
                                                            <div><?php echo e($ultVersionF); ?></div>
                                                        </div>
                                                    </div>

                                                    <p class="text-muted mb-2 small">
                                                        <?php echo e($descripcion); ?>

                                                    </p>

                                                    <div class="mt-auto d-flex flex-wrap gap-3 small text-muted align-items-center">
                                                        
                                                        

                                                        <span class="d-flex align-items-center gap-2 flex-wrap">
                                                            <i class="fa-solid fa-microchip me-1"></i>
                                                            <?php if($plats instanceof \Illuminate\Support\Collection ? $plats->isEmpty() : empty($plats)): ?>
                                                                <span>Plataformas: —</span>
                                                            <?php else: ?>
                                                                <?php $__currentLoopData = ($plats instanceof \Illuminate\Support\Collection ? $plats : collect($plats)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php
                                                                        $icon       = $osIcon($pl->SCodigo ?? '', $pl->SNombre ?? '');
                                                                        $name       = $titleCase($pl->SNombre ?? '');
                                                                        $variants   = collect($pl->SVersionSOList ?? [])->filter()->values();
                                                                        $variantTxt = $variants->isNotEmpty() ? '('.$variants->join(', ').')' : '';
                                                                    ?>
                                                                    <span class="badge bg-light border text-body d-inline-flex align-items-center gap-1">
                                                                        <i class="<?php echo e($icon); ?>"></i>
                                                                        <span><?php echo e($name); ?></span>
                                                                        <?php if($variantTxt): ?>
                                                                            <span class="text-muted"><?php echo e($variantTxt); ?></span>
                                                                        <?php endif; ?>
                                                                    </span>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="col-12">
                                            <div class="alert alert-light border mb-0">
                                                No hay proyectos disponibles para mostrar.
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <style>
        /* --------- Paleta y animación --------- */
        :root{
            --dark-1:#0A0A2A;
            --dark-2:#13063E;
            --accent-1:#4a3b9e;
            --cyan-1:#73ecf4;
            --cyan-2:#61e2ea;
            --cyan-3:#3eb5bd;
            --ink-1:#001725;
        }

        .page-fade{ animation:fadeInPage .6s ease forwards; opacity:0 }
        @keyframes fadeInPage{ to{ opacity:1 } }

        /* --------- Franja superior (Support Strip) --------- */
        .support-strip{
            background: linear-gradient(135deg, var(--cyan-1) 0%, var(--cyan-2) 35%, var(--cyan-3) 100%);
            border-bottom: 1px solid rgba(0,0,0,.06);
        }
        .support-title{
            font-size: clamp(1.05rem, 1.2vw + .7rem, 1.35rem);
            letter-spacing:.2px;
        }
        .support-subtitle{
            font-size: .95rem;
            opacity:.85;
        }
        .support-link{
            color:#0b7285;
            text-decoration: underline;
            text-underline-offset: 2px;
        }
        .support-link:hover{
            color:#085d6d;
            text-decoration-thickness: 2px;
        }
        .support-dot{
            width:.55rem; height:.55rem; display:inline-block; border-radius:50%;
            background: radial-gradient(120% 120% at 20% 20%, var(--cyan-1) 0%, var(--cyan-2) 45%, var(--cyan-3) 100%);
            box-shadow:0 0 0 3px rgba(0,194,232,.2);
            margin-right:.5rem; transform: translateY(-1px);
        }

        /* --------- Interacción tarjetas --------- */
        .hoverable{ transition: transform .08s ease, box-shadow .2s ease; cursor:pointer }
        .hoverable:hover{ transform: translateY(-1px); box-shadow: 0 .5rem 1.25rem rgba(0,0,0,.12) }

        /* Deshabilitado visual */
        .software-item.is-disabled{ opacity:.6; cursor:not-allowed }
        .software-item.is-disabled.hoverable:hover{ transform:none; box-shadow:none }

        /* --------- Layout uniforme (grid) --------- */
        .software-item{
            display:grid;
            grid-template-columns:112px 1fr;
            gap:16px;
            padding:.875rem;
            border-radius:.5rem;
            min-height:132px;
        }
        .software-item .thumb-wrap{
            width:112px; aspect-ratio:1/1; overflow:hidden; border-radius:.5rem;
            align-self:center; position:relative; background:#f2f2f2;
        }
        .software-item .thumb-img{ width:100%; height:100%; object-fit:cover; display:block }
        .thumb-placeholder{
            width:100%; height:100%; display:grid; place-items:center; font-size:.8rem; color:#6c757d;
            border:1px dashed rgba(0,0,0,.15);
            background:linear-gradient(135deg,#fafafa 0%,#f0f0f0 100%);
            border-radius:.5rem;
        }
        .software-item .card-body{ padding:0; display:flex; flex-direction:column; text-align:left }
        .software-item .card-body .d-flex.justify-content-between{ align-items:center; gap:.5rem }
        .software-item h6{ margin:0; font-weight:600; line-height:1.2 }

        /* Descripción: 2 líneas */
        .software-item p.text-muted{
            margin:.35rem 0 .25rem;
            display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden;
            min-height:calc(1em * 1.5 * 2);
        }

        .software-item .mt-auto{ margin-top:auto !important; display:flex; flex-wrap:wrap; gap:1rem; align-items:center }

        .badge.bg-warning-subtle,
        .badge.bg-info-subtle,
        .badge.bg-success-subtle{ border-width:1px !important }

        /* --------- Responsivo --------- */
        @media (max-width: 575.98px){
            .software-item{
                grid-template-columns:1fr;
                padding:.75rem .75rem 1rem;
            }
            .software-item .thumb-wrap{
                width:100%; max-width:360px; margin:0 auto .5rem;
            }
            .software-item .text-end.small{ text-align:left !important }
        }
    </style>

    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Clic en tarjeta:
            document.querySelectorAll('.software-item').forEach(function (card) {
                card.addEventListener('click', function (e) {
                    if (this.dataset.disabled === '1') {
                        e.preventDefault();
                        return;
                    }
                    const route = this.getAttribute('data-route');
                    if (route && route !== '#') {
                        window.location.href = route;
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\noil_control_de_obra\resources\views/web/descargas.blade.php ENDPATH**/ ?>